/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.internal.misc.Assert;

public class PartTester {
    static /* synthetic */ Class class$0;

    private PartTester() {
    }

    public static void testEditor(IEditorPart part) throws Exception {
        PartTester.testWorkbenchPart(part);
        Assert.isTrue(part.getEditorSite() == part.getSite());
        IEditorInput input = part.getEditorInput();
        Assert.isNotNull(input);
        PartTester.testEditorInput(input);
        part.isDirty();
        part.isSaveAsAllowed();
        part.isSaveOnCloseNeeded();
    }

    public static void testEditorInput(IEditorInput input) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        input.getAdapter(clazz);
        Assert.isNotNull(input.getName());
        Assert.isNotNull(input.getToolTipText());
        IPersistableElement persistableElement = input.getPersistable();
        if (persistableElement != null) {
            Assert.isNotNull(persistableElement.getFactoryId());
        }
    }

    private static void testWorkbenchPart(IWorkbenchPart part) throws Exception {
        IPropertyListener testListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
            }
        };
        part.addPropertyListener(testListener);
        part.removePropertyListener(testListener);
        Assert.isTrue(part.equals(part));
        Assert.isTrue(!part.equals(new Integer(32)));
        Object partAdapter = part.getAdapter(part.getClass());
        Assert.isTrue(partAdapter == null || partAdapter == part);
        Assert.isNotNull(part.getTitle());
        Assert.isNotNull(part.getTitleImage());
        Assert.isNotNull(part.getTitleToolTip());
        Assert.isNotNull(part.toString());
        part.hashCode();
        if (part instanceof IWorkbenchPart2) {
            PartTester.testWorkbenchPart2((IWorkbenchPart2)part);
        }
    }

    private static void testWorkbenchPart2(IWorkbenchPart2 part) throws Exception {
        Assert.isNotNull(part.getContentDescription());
        Assert.isNotNull(part.getPartName());
    }

    public static void testView(IViewPart part) throws Exception {
        Assert.isTrue(part.getSite() == part.getViewSite());
        PartTester.testWorkbenchPart(part);
    }
}

