/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.io.Serializable;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;

/**
 * ファイル選択プロパティ定義
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FilePropertyDefine extends PropertyDefine implements Serializable {
	private static final long serialVersionUID = -4007276161116837660L;

	/**
     * コンストラクタ
     */
    public FilePropertyDefine() {
        m_cellEditor = new FileDialogCellEditor();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        return value.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        return element.getValue();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        element.setValue(value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {

    }
}