/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.logtransfer.composite.LogTransferFileListComposite;

/**
 * 転送対象ログファイルテーブルのSelectionChangedListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferFileSelectionChangedListener implements
ISelectionChangedListener {
	
	protected LogTransferFileListComposite m_composite;
	
	/**
	 * コンストラクタ
	 * 
	 * @param composite
	 */
	public LogTransferFileSelectionChangedListener(LogTransferFileListComposite composite) {
		m_composite = composite;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
			//選択行を取得
			ArrayList info = (ArrayList) ((StructuredSelection) event
					.getSelection()).getFirstElement();
			m_composite.setSelectItem(info);
		} else {
			m_composite.setSelectItem(null);
		}
	}
}