/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.bean.TableColumnInfo;

/**
 * 文字列監視の判定情報一覧のテーブルビューアークラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringValueListTableViewer extends TableViewer {

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @since 2.1.0
     * 
     * @see org.eclipse.jface.viewers.TableViewer#TableViewer(org.eclipse.swt.widgets.Composite)
     * @see com.clustercontrol.monitor.run.composite.StringValueListTableLabelProvider
     */
    public StringValueListTableViewer(Composite parent) {
        super(parent);
        setLabelProvider(new StringValueListTableLabelProvider());
        setContentProvider(new ArrayContentProvider());
    }

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @since 2.1.0
     * 
     * @see org.eclipse.swt.SWT
     * @see org.eclipse.jface.viewers.TableViewer#TableViewer(org.eclipse.swt.widgets.Composite)
     * @see com.clustercontrol.monitor.run.composite.StringValueListTableLabelProvider
     */
    public StringValueListTableViewer(Composite parent, int style) {
        super(parent, style);
        setLabelProvider(new StringValueListTableLabelProvider());
        setContentProvider(new ArrayContentProvider());
    }

    /**
     * インスタンスを返します。
     * 
     * @param table テーブル
     * @since 2.1.0
     * 
     * @see org.eclipse.jface.viewers.TableViewer#TableViewer(org.eclipse.swt.widgets.Composite)
     * @see com.clustercontrol.monitor.run.composite.StringValueListTableLabelProvider
     */
    public StringValueListTableViewer(Table table) {
        super(table);
        setLabelProvider(new StringValueListTableLabelProvider());
        setContentProvider(new ArrayContentProvider());
    }

    /**
     * テーブルカラムを作成します。
     * 
     * @param tableColumnList 判定情報一覧のテーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * @since 2.1.0
     * 
     * @see com.clustercontrol.bean.TableColumnInfo#TableColumnInfo(java.lang.String, int, int, int)
	 * @see com.clustercontrol.monitor.run.bean.StringValueListTabelDefine
     */
    public void createTableColumn(ArrayList tableColumnList) {

        for (int i = 0; i < tableColumnList.size(); i++) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo) tableColumnList.get(i);
            TableColumn column = new TableColumn(getTable(), tableColumnInfo.getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());
        }
    }
}