/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import com.clustercontrol.notify.bean.NotifyInfo;


/**
 * 通知情報と通知情報の状態種別を保持するクラスです。<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyInfoContext
implements java.io.Serializable
{
	private static final long serialVersionUID = -5048460873959498381L;
	
	/** 作成（状態種別）。 */
	public static final int TYPE_ADD = 0;
	/** 変更（状態種別）。 */
	public static final int TYPE_UPDATE = 1;
	/** 削除（状態種別）。 */
	public static final int TYPE_DELETE = 2;
	
	
	/** 
	 * 状態種別（作成/変更/削除）。
	 * 
	 * @see #TYPE_ADD
	 * @see #TYPE_DELETE
	 * @see #TYPE_UPDATE
	 */
	private int m_type = TYPE_ADD;
	
	/** 通知ID。 */ 
	private String m_notifyId = null;
	
	/** 通知情報。 */
	private NotifyInfo m_notifyInfo = null;
	
	
	/**
	 * コンストラクタ。
	 */
	public NotifyInfoContext() {
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param type 状態種別
	 * @param notifyId 通知ID
	 * @param notifyInfo 通知情報
	 * 
	 * @see #TYPE_ADD
	 * @see #TYPE_DELETE
	 * @see #TYPE_UPDATE
	 */
	public NotifyInfoContext(int type, String notifyId, NotifyInfo notifyInfo) {
		super();
		
		this.m_type = type;
		this.m_notifyId = notifyId;
		this.m_notifyInfo = notifyInfo;
	}
	
	/**
	 * 通知情報を返します。
	 * 
	 * @return 通知情報
	 */
	public NotifyInfo getNotifyInfo() {
		return m_notifyInfo;
	}
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @param notifyInfo 通知情報
	 */
	public void setNotifyInfo(NotifyInfo notifyInfo) {
		this.m_notifyInfo = notifyInfo;
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId(String notifyId) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 状態種別を返します。
	 * 
	 * @return 状態種別
	 * 
	 * @see #TYPE_ADD
	 * @see #TYPE_DELETE
	 * @see #TYPE_UPDATE
	 */
	public int getType() {
		return m_type;
	}
	
	/**
	 * 状態種別を設定します。
	 * 
	 * @param type 状態種別
	 * 
	 * @see #TYPE_ADD
	 * @see #TYPE_DELETE
	 * @see #TYPE_UPDATE
	 */
	public void setType(int type) {
		this.m_type = type;
	}
}
