/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブを実行するクラスです。
 * 
 * マネージャにSessionBean経由でアクセスし、ジョブを実行する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RunJob {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * 引数で指定されたジョブIDのジョブを実行する
	 * 
	 * @param jobId ジョブID
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#runJob(java.lang.String)
	 */
	public void runJob(String jobId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		try {
			job.runJob(jobId);
		} catch (Exception e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		}
	}
}
