/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.composite.tree;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import com.clustercontrol.util.Messages;

/**
 * スコープ付き収集情報コンポジットクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CollectorBasicScopeComposite extends Composite {
	
    // ----- instance フィールド ----- //

    /** 収集項目ID */
    private Text m_textCollectorId = null;

    /** 詳細 */
    private Text m_textDescription = null;
	
	/** スコープ */
    private Text m_textScope = null;
    
    /** スコープ参照ボタン */
    private Button m_buttonScope = null;
    
    /** 選択されたスコープのファシリティID */
    private String m_facilityId = null;

    /** ファシリティ選択が変わった際に更新されるコンポジット */
    private Composite updateComposite = null;
    
	public static final int WIDTH_TITLE = 3;
	public static final int WIDTH_VALUE = 2;

    // ----- instance フィールド ----- //


    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     */
    public CollectorBasicScopeComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }
    
    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
    	
    	// 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;
        this.setLayout(layout);
        
        /*
         * 収集項目ID
         */
        // ラベル
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("collection.id") + " : ");
        // テキスト
        this.m_textCollectorId = new Text(this, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textCollectorId.setLayoutData(gridData);
        this.m_textCollectorId.addVerifyListener(
        		new StringVerifyListener(DataRangeConstant.VARCHAR_256));
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * 説明
         */
        // ラベル
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("description") + " : ");
        // テキスト
        this.m_textDescription = new Text(this, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData(gridData);
        this.m_textDescription.addVerifyListener(
        		new StringVerifyListener(DataRangeConstant.VARCHAR_1024));
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);      
        
        /*
         * スコープ
         */
        // ラベル
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("scope") + " : ");
        // テキスト
        this.m_textScope = new Text(this, SWT.BORDER | SWT.LEFT | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textScope.setLayoutData(gridData);
        // 参照ボタン
        m_buttonScope = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_buttonScope.setLayoutData(gridData);
        m_buttonScope.setText(Messages.getString("refer"));

        m_buttonScope.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	// シェルを取得
                Shell shell = getShell();
                
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell);
                if (dialog.open() == IDialogConstants.OK_ID) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    m_facilityId = info.getFacilityId();
                    if (info.getType() == FacilityConstant.TYPE_NODE) {
                        m_textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(
                                ClusterControlPlugin.getDefault()
                                        .getSeparator());
                        m_textScope.setText(path.getPath(item));
                    }
                    
                    // 登録されているコンポジットの状態を更新します。
                    if(updateComposite != null){
                    	updateComposite.setData("FacilityId", m_facilityId);
                    	updateComposite.update();
                    }
                }
            }
        });
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * 各項目に入力値を設定します。
     * 
     * @param info 設定値として用いる監視情報
     */
	public void setInputData(RecordCollectorData info) {
		if(info != null){
			 if (info.getCollectorID() != null) {
				 this.m_textCollectorId.setText(info.getCollectorID());
			 }
		     if (info.getLabel() != null) {
		    	 this.m_textDescription.setText(info.getLabel());
		     }
		}
		
		if(info != null){
			if (info.getScopePath() != null) {
				this.m_textScope.setText(info.getScopePath());
			}
			if (info.getFacilityID() != null) {
				this.m_facilityId = info.getFacilityID();
			}
		}
	}
	
	/**
     * 入力値を用いて監視情報を生成します。
     * 
     * @return 検証結果
     */
	public ValidateResult createInputData(RecordCollectorData info) {
		
		if(info != null){
			// 収集IDを検証
			if (this.m_textCollectorId.getText() != null
					&& !"".equals((this.m_textCollectorId.getText()).trim())) {
				info.setCollectorID(this.m_textCollectorId.getText());
			} else {
				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.1"));
			}
			
			// 説明は検証なし
			if (this.m_textDescription.getText() != null
					&& !"".equals((this.m_textDescription.getText()).trim())) {
				info.setLabel(this.m_textDescription.getText());
			}
			
			
			// スコープを検証
			if (this.m_textScope.getText() != null
					&& !"".equals((this.m_textScope.getText()).trim())) {
				info.setFacilityID(this.m_facilityId);
			}
			else{
				return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.hinemos.3"));
			}
		}
		return null;
	}
	
	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		this.m_textCollectorId.setEnabled(enabled);
		this.m_textDescription.setEnabled(enabled);
		
		this.m_textScope.setEnabled(enabled);
		this.m_buttonScope.setEnabled(enabled);
	}
	
	/**
     * 無効な入力値の情報を設定します
     *  
     */
    private ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();   	
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }

    /** 
     * 現在選択されているファシリティIDを返します。
     * @return ファシリティID
     */
	public String getFacilityId() {
		return m_facilityId;
	}

	/**
	 * ファシリティの指定が変更になった場合にupdateが呼ばれるコンポジットを設定します。
	 * @param updateComposite 更新対象コンポジット
	 */
	public void setUpdateComposite(Composite updateComposite) {
		this.updateComposite = updateComposite;
	}
}