/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import javax.ejb.DuplicateKeyException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.dialog.RecordSetDialog;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;

/**
 * 新規に収集設定を行うダイアログをオープンするアクションクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class SetCollectorAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.SetCollectorAction";
	
    private static RecordSetDialog setDialog;

    private IViewPart viewPart; // ビュー

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
		// アクセス権なしの場合、エラーダイアログを表示する
    	if(!RecordController.getInstance().checkPermissionRead() || 
    			!RecordController.getInstance().checkPermissionWrite() ||
    			!RecordController.getInstance().checkPermissionExecute()){
    		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
    				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
    		return;
    	}
    	
        /*
         * controllerの初期化をします。
         */
        RecordController controller = RecordController.getInstance();
        // マネージャとの接続に失敗した場合はエラーダイアログを表示
        if (controller == null) {
            MessageDialog.openError(this.viewPart.getSite().getShell(),
                    Messages.getString("MESSAGE_0020"), // "確認" 
                    Messages.getString("CONNECTION_ERROR_MESSAGE"));
            return;
        }

        Shell shell = new Shell();
        setDialog = new RecordSetDialog(shell);

        /*
         * ダイアログに情報を渡す
         */
        int ret = setDialog.open();
        
        if (ret == IDialogConstants.OK_ID) {
        	
        	CollectorProperty property = setDialog.getInputData();
        	
        	//データをマネージャに送り収集を開始します。
        	try {
        		if (!controller.registRecordCollector(property)) {
        			// 収集の開始に失敗した場合はエラーダイアログを表示
        			MessageDialog
        			.openError(
        					this.viewPart.getSite().getShell(),
        					Messages.getString("MESSAGE_0020"), // "確認"
        					Messages.getString("START_COLLECTOR_ERROR_MESSAGE"));
        		}
        	} catch (DuplicateKeyException e) {
        		// 収集IDが重複している旨をメッセージ表示
        		MessageDialog
        		.openError(
        				this.viewPart.getSite().getShell(),
        				Messages.getString("MESSAGE_0020"), // "確認"
        				Messages.getString("START_COLLECTOR_DUPLICATEKEY_MESSAGE"));
        	}
        	
        	//収集中のリストのリフレッシュを行います。
        	IWorkbenchPage page = PlatformUI.getWorkbench()
        	.getActiveWorkbenchWindow().getActivePage();
        	CurrentListView currentListView = (CurrentListView) page
        	.findView(Messages.getString("VIEW_CURRENT_LIST"));
        	
        	currentListView.refresh();
        } else if (ret == IDialogConstants.CANCEL_ID) {
        	// [Cancel]ボタンもしくは×を押下
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}