/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;
import java.util.ArrayList;


/**
 * 収集情報のカテゴリーを保持するクラス
 * 実績グラフ表示の際に設定及び、グラフ描画のカテゴリー（CPU,Memmory,Disk,Net)の情報を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCategoryInfo implements ICollectorItemInfo, Serializable {
    private String categoryCode;

    private String categoryName;

    private ArrayList<CollectorItemCodeInfo> itemCodeList; // 収集項目コードのリスト

    public CollectorItemCategoryInfo(String categoryCode, String categoryName) {
        this.categoryCode = categoryCode;
        this.categoryName = categoryName;
        this.itemCodeList = new ArrayList<CollectorItemCodeInfo>();
    }

    /**
     * カテゴリに収集項目を追加します。
     * 
     * @param item
     */
    public void addItem(CollectorItemCodeInfo item) {
        itemCodeList.add(item);
    }

    /**
     * カテゴリに含まれる収集項目を返します。
     * 
     * @param index
     */
    public CollectorItemCodeInfo getItem(int index) {
        return (CollectorItemCodeInfo) itemCodeList.get(index);
    }

    /**
     * @return categoryCode を戻します。
     */
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * @param categoryCode
     *            categoryCode を設定。
     */
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    /**
     * @return categoryName を戻します。
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * @param categoryName
     *            categoryName を設定。
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    /**
     * @return itemCodeList を戻します。
     */
    public ArrayList getItemCodeList() {
        return itemCodeList;
    }

    /**
     * @param itemCodeList
     *            itemCodeList を設定。
     */
    public void setItemCodeList(ArrayList<CollectorItemCodeInfo> itemCodeList) {
        this.itemCodeList = itemCodeList;
    }

	public String getName() {
		return getCategoryName();
	}

	public String getCode() {
		return getCategoryCode();
	}
}