/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.ping.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.ping.bean.PingResult;
import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;

/**
 * アドレスが到達可能かどうか確認するクラスです。
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ReachAddressFping {
	
	protected static Log m_log = LogFactory.getLog( ReachAddressFping.class );
	
	/**Fring 実行パス**/
	public static  String  fpingPath;
	
	
	
	/** 送信回数 */
	private int m_sentCount	
	 = PingProperties.getM_fpingCount() ;
	
	/** 送信間隔（ミリ秒） */
	private int m_sentInterval = PingProperties.getM_fpingInterval() ;
	
	/** タイムアウト（ミリ秒） */
	private int m_timeout = PingProperties.getM_fpingTimeout() ;
	
	/**実行結果のエラーメッセージ**/
	private ArrayList m_errMsg;
	
	/**実行結果のメッセージ**/
	private ArrayList m_resultMsg;	
	
	
	/**
	 * コンストラクタ
	 */
	public ReachAddressFping(int sentNum, int sentInterval, int timeout){
		
		m_sentCount = sentNum;
		m_sentInterval = sentInterval; // sec  to msec
		m_timeout = timeout;
		
		PingProperties.getProperties();
		fpingPath=PingProperties.getM_fpingPath();
	}
	
	/**
	 * アドレスを取得し、到達可能かどうかをテストします
	 * 
	 * @param info
	 * @return PING監視ステータス
	 */
	public boolean isReachable(String[] hosts) {
		
		
		Process process = null ;//fpingプロセス
		int	m_exitValue = 0; //fpingコマンドの戻り値
		
		
		//コマンド実行する配列を初期化する。
		int length = 5 + hosts.length;
		String cmd[] = new String[length]; 
		
		cmd[0] = fpingPath;
		cmd[1] = "-C" + m_sentCount; 
		cmd[2] = "-p" + m_sentInterval;
		cmd[3] = "-t" + m_timeout;
		cmd[4] = "-q" ; 
		
		//コマンドを実行するために値を詰め替えます。
		for(int i = 0 ; i < hosts.length; i++ ){
			cmd[i+5]=hosts[i];
		}
		
		
		try {      	
			process = Runtime.getRuntime().exec(cmd); 	
			
			if(process != null){
				//標準出力、エラー出力読み取り開始
				StreamReader errStreamReader = new StreamReader(process.getErrorStream());
				errStreamReader.start();
				StreamReader inStreamReader = new StreamReader(process.getInputStream());
				inStreamReader.start();
				
				
//				コマンド実行待機
				m_exitValue= process.waitFor();
				
				//標準出力取得
				
				inStreamReader.join();	
				m_resultMsg = inStreamReader.getResult();
				m_log.debug("isReachable() :" + inStreamReader.getResult().toString());
				
				errStreamReader.join();
				m_errMsg = errStreamReader.getResult();
				m_log.debug("isReachable() :" +errStreamReader.getResult().toString());
				
				
			}
		} catch (IOException e) {
			
			
			m_errMsg = new ArrayList();
			m_errMsg.add(e.getMessage());
			m_log.error("isReachable() :" + e.getMessage());
			return  false;
			
		}
		catch (InterruptedException e) {
			
			m_errMsg = new ArrayList();
			m_errMsg.add(e.getMessage());
			m_log.error("isReachable() :" + e.getMessage());
			return  false;
		}
		finally{
			if(process != null){
				process.destroy();
			}
		}
		if(m_exitValue == 0 || m_exitValue == 1){
			//fpingの戻り値が0ならば成功を返す
			//fpingは対象ノードがunreachableだと1をかえすので、1でも正常終了とする。
			return true;
		}else{
			//fpingの戻り値が!0 or !1ならば失敗を返す
			return false;
			
		}
	
	}


	/**
	 * 実行プロセスの標準、エラー出力読み取りスレッド
	 * コンストラクタで渡されたストリームを読み出し、文字列として格納する 
	 */
	class StreamReader extends Thread {
		
		BufferedReader m_br;
		ArrayList m_ret;
		InputStream m_ist;
		
		/**
		 * コンストラクタ
		 * @param ist 入力ストリーム
		 */
		public StreamReader(InputStream ist) {
			super();
			m_br = new BufferedReader(new InputStreamReader(ist));
			m_ist = ist;
			m_ret = new ArrayList();
		}
		
		
		public void run() {
			
			
			try {
				while(true){
					
					String outputString = m_br.readLine();
					
					if(outputString != null){
						m_ret.add(outputString);
					}
					else{
						break;
					}
					
				}
				
			} catch (IOException e) {
				m_log.error(e.getMessage(), e);
				
			}
			try {
				
				/**
				 * コネクションクローズ
				 */
				m_ist.close();
				
			} catch (IOException e) {
			}
			
		}
		/**
		 * 読み出し結果のArrayList
		 * @return ストリームから読み出したStringを一行毎に入れたArrayList
		 */
		public ArrayList getResult() {
			return m_ret;
		}
	}
	
	
	public  ArrayList getM_errMsg() {
		return m_errMsg;
	}
	
	public ArrayList getM_resultMsg() {
		return m_resultMsg;
	}
	
	
	
	
	
}
