/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.snmptrap.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoUtil;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapFacilityInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 監視情報検索クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SelectMonitorInfo {
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorInfo.class );
	
	/**
	 * 監視情報取得
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	public MonitorSnmpTrapInfo getMonitorInfo(String monitorId) throws FinderException, NamingException, CreateException {
		
		MonitorSnmpTrapInfo monitorInfo = null;
		try 
		{
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			
			// 監視情報を取得
			SnmpTrapInfoLocal info = 
				SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(
						new SnmpTrapInfoPK(monitorId));
	
			
			MonitorInfoPK mipk = new MonitorInfoPK(info.getMonitorId(),
													MonitorConstant.STRING_SNMPTRAP);
			
		    MonitorInfoLocal infoLocal = MonitorInfoUtil.getLocalHome().findByPrimaryKey(mipk);
			
			// スコープの取得
			String facilityPath = repository.getFacilityPath(info.getFacilityId(), null);
			
			
			monitorInfo = new MonitorSnmpTrapInfo();
			
			//FIXME
			/* Monitor情報から何をロードすべきかわからないのでとりあえずのnotNull
			 * の項目のみを埋めておく*/
			monitorInfo.setMonitorType(infoLocal.getMonitorType());
			monitorInfo.setMonitorTypeId(MonitorConstant.STRING_SNMPTRAP);
			
			monitorInfo.setMonitorId(info.getMonitorId());
			monitorInfo.setDescription(info.getDescription());
			monitorInfo.setFacilityId(info.getFacilityId());
			monitorInfo.setScope(facilityPath);
			monitorInfo.setCommunityName(info.getCommunityName());
			monitorInfo.setNotifyId(info.getNotifyId());
			monitorInfo.setApplication(info.getApplication());
			monitorInfo.setValid(info.getValidFlg().intValue());
			monitorInfo.setCalendarId(info.getCalendarId());
			monitorInfo.setRegDate(info.getRegDate());
			monitorInfo.setUpdateDate(info.getUpdateDate());
			monitorInfo.setRegUser(info.getRegUser());
			monitorInfo.setUpdateUser(info.getUpdateUser());
			monitorInfo.setCheckMode(info.getCheckMode());
			
			// 監視OID情報取得
			Collection oids = info.getSnmpTrapOidInfo();
			
			ArrayList<MonitorSnmpTrapOidInfo> oidList = 
				new ArrayList<MonitorSnmpTrapOidInfo>();
			
			Iterator itr = oids.iterator();
			while(itr.hasNext()){
				SnmpTrapOidInfoLocal oid = (SnmpTrapOidInfoLocal)itr.next();
				
				MonitorSnmpTrapOidInfo oidInfo = new MonitorSnmpTrapOidInfo();
				oidInfo.setMonitorId(oid.getMonitorId());
				oidInfo.setMib(oid.getMib());
				oidInfo.setTrapOid(oid.getTrapOid());
				oidInfo.setGenericId(oid.getGenericId().intValue());
				oidInfo.setSpecificId(oid.getSpecificId().intValue());
				
				//監視マスタ情報を取得
				SnmpTrapMasterLocal master = 
					SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(
							new SnmpTrapMasterPK(
									oid.getMib(), 
									oid.getTrapOid(), 
									oid.getGenericId(), 
									oid.getSpecificId()));
				
				oidInfo.setTrapName(master.getUei());
				oidInfo.setValidFlg(oid.getValidFlg().intValue());
				oidInfo.setPriority(oid.getPriority().intValue());
				oidInfo.setLogmsg(oid.getLogmsg());
				oidInfo.setDescr(oid.getDescr());
				oidList.add(oidInfo);
			}
			monitorInfo.setOidInfos(oidList);
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "004", args);
			m_log.debug("getMonitorInfo():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "004", args);
			m_log.debug("getMonitorInfo():" + e.getMessage());
			throw e;
		}
		
		// ジョブ連携のため追加
		// SNMPトラップ監視機能の設定情報を保持するテーブル cc_snmp_trap_info には、
		// ジョブ連携用の情報を保持するカラムがないため、cc_monitor_infoテーブルと
		// cc_monitor_numeric_value_infoテーブルにその情報を保持している。
		// 両テーブルから該当監視項目のジョブ連携情報を取得する。
		
		// 監視情報（cc_monitor_info）から、ジョブ実行フラグのみを取得
		try{
			MonitorInfoPK mipk = new MonitorInfoPK(monitorId, MonitorConstant.STRING_SNMPTRAP);
			MonitorInfoLocal infoLocal = MonitorInfoUtil.getLocalHome().findByPrimaryKey(mipk);
			monitorInfo.setJobRun(infoLocal.getJobRun());
			
			// c_monitor_numeric_value_infoテーブルからジョブ連動の情報取得
			Collection ct = MonitorNumericValueInfoUtil.getLocalHome().
			findByMonitorTypeIdAndMonitorId(MonitorConstant.STRING_SNMPTRAP, monitorId);
			Iterator itr = ct.iterator();
			
			ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
			
			MonitorNumericValueInfoLocal local = null;
			while(itr.hasNext()){
				local = (MonitorNumericValueInfoLocal)itr.next();
				MonitorNumericValueInfo value = new MonitorNumericValueInfo(
						local.getMessage(),
						local.getMessageId(),
						local.getMonitorId(),
						local.getMonitorTypeId(),
						local.getPriority(),
						local.getThresholdLowerLimit(),
						local.getThresholdUpperLimit(),
						local.getJobRun(),
						local.getJobId(),
						local.getJobInhibitionFlg(),
						local.getJobFailurePriority());
				valueList.add(value);
			}
			if(valueList.size() != 0){
				monitorInfo.setJudgementInfo(valueList);
			}
		} catch (FinderException e) {
			// ジョブ連携の定義がDBに登録されていない場合は、ジョブ連携情報を付加しない
			// ver2.2.1まではSNMPトラップ監視機能でのジョブ連携が実装されておらず、
			// SNMPトラップ監視機能で、cc_monitor_infoとcc_monitor_numeric_value_infoテーブルを
			// 利用していないため、ver2.2.1から移行されたDBでは、このルートを通る
			m_log.warn("getMonitorInfo():" + " MonitorInfo not found '" + monitorId + "', " + e.getMessage());
			monitorInfo.setJobRun(YesNoConstant.TYPE_NO);
		}
		
		return monitorInfo;
	}
	
	/**
	 * 監視一覧取得
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getMonitorList() throws CreateException, FinderException, NamingException {
		
		ArrayList list = null;
		try 
		{
			// 監視情報を取得
			Collection ct = SnmpTrapInfoUtil.getLocalHome().findAll();
			
			//2次元配列に変換
			list = collectionToArray(ct);
			
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "005", args);
			m_log.debug("getMonitorList():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "005", args);
			m_log.debug("getMonitorList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "005", args);
			m_log.debug("getMonitorList():" + e.getMessage());
			throw e;
		}
		return list;
	}
	
	/**
	 * 監視情報をObjectの2次元配列に格納
	 * 
	 * @param ct
	 * @return Objectの2次元配列
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException{
		
		RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
		
		ArrayList list = new ArrayList();
		Iterator itr = ct.iterator();
		while(itr.hasNext())
		{
			SnmpTrapInfoLocal monitor = (SnmpTrapInfoLocal)itr.next();
			// 監視OID情報取得
			Collection oids = monitor.getSnmpTrapOidInfo();
			
			// スコープの取得
			String facilityPath = repository.getFacilityPath(monitor.getFacilityId(), null);
			
			ArrayList info = new ArrayList();
			info.add(monitor.getMonitorId());
			info.add(monitor.getDescription());
			info.add(oids.size());
			info.add(facilityPath);
//			info.add(monitor.getCalendarId());
			info.add(monitor.getValidFlg().intValue());
			info.add(monitor.getRegUser());
			info.add(monitor.getRegDate() == null ? null:new Date(monitor.getRegDate().getTime()));
			info.add(monitor.getUpdateUser());
			info.add(monitor.getUpdateDate() == null ? null:new Date(monitor.getUpdateDate().getTime()));
			list.add(info);
		}
		return list;
	}
	
	/**
	 * MIB一覧取得
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList<String> getMibList() throws FinderException, NamingException {
		
		ArrayList<String> mibList = null;
		try 
		{
			// 監視マスタMIB情報を取得
			Collection mibs = 
				SnmpTrapMibMasterUtil.getLocalHome().findAll();
			
			mibList = new ArrayList<String>();
			
			Iterator itr = mibs.iterator();
			while(itr.hasNext()){
				SnmpTrapMibMasterLocal mib = (SnmpTrapMibMasterLocal)itr.next();
				
				mibList.add(mib.getMib());
			}
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "006", args);
			m_log.debug("getMibList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "006", args);
			m_log.debug("getMibList():" + e.getMessage());
			throw e;
		}
		return mibList;
	}
	
	/**
	 * マスタ情報一覧取得
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList<SnmpTrapMasterInfo> getMasterList(String mib) throws FinderException, NamingException {
		
		ArrayList<SnmpTrapMasterInfo> masterList = null;
		try 
		{
			//監視マスタMIB情報を取得
			Collection masters = null;
			if(mib == null || mib.equals("")){
				masters = 
					SnmpTrapMasterUtil.getLocalHome().findAll();
			}
			else{
				masters = 
					SnmpTrapMasterUtil.getLocalHome().findByMib(mib);	
			}
			
			masterList = new ArrayList<SnmpTrapMasterInfo>();
			
			Iterator itr = masters.iterator();
			while(itr.hasNext()){
				SnmpTrapMasterLocal master = (SnmpTrapMasterLocal)itr.next();
				
				SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
				info.setMib(master.getMib());
				info.setTrapOid(master.getTrapOid());
				info.setGenericId(master.getGenericId().intValue());
				info.setSpecificId(master.getSpecificId().intValue());
				info.setUei(master.getUei());
				info.setPriority(master.getPriority());
				info.setLogmsg(master.getLogmsg());
				info.setDescr(master.getDescr());
				masterList.add(info);
			}
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "007", args);
			m_log.debug("getMasterList():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = null;
			apllog.put("SYS", "007", args);
			m_log.debug("getMasterList():" + e.getMessage());
			throw e;
		}
		return masterList;
	}
	
	/**
	 * マスタ情報取得
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public SnmpTrapMasterInfo getMasterInfo(SnmpTrapMasterPK pk) throws FinderException, NamingException {
		
		m_log.debug("getMasterInfo() : start");
		SnmpTrapMasterInfo info = null;
		try 
		{
			//監視マスタMIB情報を取得
			SnmpTrapMasterLocal master = SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(pk);
			
			info = new SnmpTrapMasterInfo();
			info.setMib(master.getMib());
			info.setTrapOid(master.getTrapOid());
			info.setGenericId(master.getGenericId().intValue());
			info.setSpecificId(master.getSpecificId().intValue());
			info.setUei(master.getUei());
			info.setLogmsg(master.getLogmsg());
			info.setDescr(master.getDescr());
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = {pk.mib, pk.trapOid, Integer.toString(pk.genericId), Integer.toString(pk.specificId)};
			apllog.put("SYS", "008", args);
			m_log.debug("getMasterInfo():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRAP", "trap");
			String[] args = {pk.mib, pk.trapOid, Integer.toString(pk.genericId), Integer.toString(pk.specificId)};
			apllog.put("SYS", "008", args);
			m_log.debug("getMasterInfo():" + e.getMessage());
			throw e;
		}
		m_log.debug("getMasterInfo() : end");
		return info;
	}
	
	/**
	 * SNMPTRAP監視ファシリティ情報取得
	 * 
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public SnmpTrapFacilityInfo getSnmpTrapFacilityInfo(String monitorId) throws CreateException, FinderException, NamingException {
		
		// SNMPTRAP監視を取得
		SnmpTrapFacilityInfo snmpTrapInfo = null;
		try 
		{
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			
			// 監視情報を取得
			SnmpTrapInfoLocal info = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(monitorId));
			
			// 監視OID情報取得
			Collection oids = info.getSnmpTrapOidInfo();
			
			if(info.getValidFlg() == ValidConstant.TYPE_VALID){
				
				snmpTrapInfo = new SnmpTrapFacilityInfo();
				
				snmpTrapInfo.setMonitorId(monitorId);
				
				String facilityId = info.getFacilityId();
				snmpTrapInfo.setFacilityId(facilityId);
				
				ArrayList<String> facilityIdList = null;
				//指定のファシリティIDがノードならば、自分自身をトラップ受信対象の
				//ファシリティに登録
				
				if(repository.isNode(facilityId)){
					facilityIdList = new ArrayList<String>();
					facilityIdList.add(facilityId);
				}
				//未登録ノードスコープの場合　
				else if(facilityId.equals(FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE) ){
					
					//自分自身を登録
					//see com.clustercontrol.snmptrap.factory.TrapSNMP.snmpReceivedTrap
					facilityIdList = new ArrayList<String>();
					facilityIdList.add(FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE);
				}
				else{
					facilityIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
				}
				snmpTrapInfo.setFacilityIdList(facilityIdList);
				
				snmpTrapInfo.setCommunityName(info.getCommunityName());
				
				ArrayList<SnmpTrapOidInfo> oidList = new ArrayList<SnmpTrapOidInfo>();
				
				snmpTrapInfo.setCheckMode(info.getCheckMode());
				
				if(snmpTrapInfo.getCheckMode() == 1 || snmpTrapInfo.getCheckMode() == 2){
					//checkMode 1 : すべてのOIDを監視
					//checkMode 2 : マスター以外のOIDを監視 
					
					/*SnmpTrapOidInfo oidInfo = new SnmpTrapOidInfo();
					 oidInfo.setTrapOid("0");
					 oidInfo.setGenericId(0);
					 oidInfo.setSpecificId(0);
					 oidList.add(oidInfo);*/
					
					
				}else{
					
					
					Iterator itrOid = oids.iterator();
					while(itrOid.hasNext()){
						SnmpTrapOidInfoLocal oid = (SnmpTrapOidInfoLocal)itrOid.next();
						
						if(oid.getValidFlg() == ValidConstant.TYPE_VALID){
							SnmpTrapOidInfo oidInfo = new SnmpTrapOidInfo();
							oidInfo.setTrapOid(oid.getTrapOid());
							oidInfo.setGenericId(oid.getGenericId());
							oidInfo.setSpecificId(oid.getSpecificId());
							oidList.add(oidInfo);
						}
					}
				}
				snmpTrapInfo.setOidList(oidList);
				
			}
		} catch (CreateException e) {
			m_log.debug("getSnmpTrapFacilityInfo():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			m_log.debug("getSnmpTrapFacilityInfo():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.debug("getSnmpTrapFacilityInfo():" + e.getMessage());
			throw e;
		}
		return snmpTrapInfo;
	}
	
	/**
	 * SNMPTRAP監視ファシリティ情報マップ取得
	 * 
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public HashMap<String, SnmpTrapFacilityInfo> getSnmpTrapFacilityMap() throws CreateException, FinderException, NamingException {
		
		m_log.debug("getSnmpTrapFacilityMap() :start");
		// SNMPTRAP監視一覧を取得
		HashMap<String, SnmpTrapFacilityInfo> map = new HashMap<String, SnmpTrapFacilityInfo>();
		try 
		{
			RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
			
			// 監視情報を取得
			Collection ct = SnmpTrapInfoUtil.getLocalHome().findAll();
			
			Iterator itr = ct.iterator();
			while(itr.hasNext())
			{
				
				SnmpTrapInfoLocal info = (SnmpTrapInfoLocal)itr.next();
				
				
				
				
				// 監視OID情報取得
				Collection oids = info.getSnmpTrapOidInfo();
				
				SnmpTrapFacilityInfo snmpTrapInfo = new SnmpTrapFacilityInfo();
				
				if(info.getValidFlg() == ValidConstant.TYPE_VALID){
					
					//有効のチェックがされている場合にデータをつくる。
					
					//監視ID
					String monitorId = info.getMonitorId();
					snmpTrapInfo.setMonitorId(monitorId);
					
					//設定ダイアログのfacilityID(スコープ)
					String facilityId = info.getFacilityId();
					snmpTrapInfo.setFacilityId(facilityId);
					
					
					//配下のノードたちのfacilityIDを格納（ダイアログ設定でノードの場合には自分自身）
					ArrayList<String> facilityIdList = null;
					if(repository.isNode(facilityId)){
						facilityIdList = new ArrayList();
						facilityIdList.add(facilityId);
					}else if(facilityId.equals(FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE)){
						
						//未登録ノードスコープの時は自分を検索対象ファシリティにします。
//						see com.clustercontrol.snmptrap.factory.TrapSNMP.snmpReceivedTrap
						facilityIdList = new ArrayList<String>();
						facilityIdList.add(FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE);	
					}
					else{
						facilityIdList = repository.getNodeFacilityIdList(facilityId, RepositoryControllerBean.ALL);
					}
					snmpTrapInfo.setFacilityIdList(facilityIdList);
					
					
					snmpTrapInfo.setCommunityName(info.getCommunityName());
					
					snmpTrapInfo.setCheckMode(info.getCheckMode());
					
					//OIDのリストを作成する。
					ArrayList<SnmpTrapOidInfo> oidList = new ArrayList<SnmpTrapOidInfo>();
					
					m_log.debug("getSnmpTrapFacilityMap() :CheckMode() " + snmpTrapInfo.getCheckMode());
					
					if(snmpTrapInfo.getCheckMode() == 1 || snmpTrapInfo.getCheckMode() == 2){
						//checkMode 1 : すべてのOIDを監視
						//checkMode 2 : マスター以外のOIDを監視 
						
						/*SnmpTrapOidInfo oidInfo = new SnmpTrapOidInfo();
						 oidInfo.setTrapOid("0");
						 oidInfo.setGenericId(0);
						 oidInfo.setSpecificId(0);
						 oidList.add(oidInfo);*/
						
						
					}else{
						
						//指定OIDのみを監視する場合。
						
						Iterator itrOid = oids.iterator();
						while(itrOid.hasNext()){
							SnmpTrapOidInfoLocal oid = (SnmpTrapOidInfoLocal)itrOid.next();
							
							if(oid.getValidFlg() == ValidConstant.TYPE_VALID){
								//ダイアログのトラップそれぞれにも"変更"で
								//有効・無効が設定できるらしい。
								SnmpTrapOidInfo oidInfo = new SnmpTrapOidInfo();
								oidInfo.setTrapOid(oid.getTrapOid());
								oidInfo.setGenericId(oid.getGenericId());
								oidInfo.setSpecificId(oid.getSpecificId());
								oidList.add(oidInfo);
							}
						}
						snmpTrapInfo.setOidList(oidList);
					}
						map.put(monitorId, snmpTrapInfo);
				}
			}
		} catch (CreateException e) {
			m_log.debug("getSnmpTrapMap():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			m_log.debug("getSnmpTrapMap():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.debug("getSnmpTrapMap():" + e.getMessage());
			throw e;
		}
		m_log.debug("getSnmpTrapFacilityMap() :end");
		return map;
	}

	public SnmpTrapMasterInfo findMasterInfo(String trapOid, int genericId, int specificId) {
	
		m_log.debug("findMasterInfo() : start");
		
		SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
		
		try {
			
			Collection masters = SnmpTrapMasterUtil.getLocalHome().findByOid(trapOid,genericId,specificId );
		
			
			if(masters.size() == 1){
			
				//マスター情報すべての場合には、
				//pkからSnmpTrapMaserInfoを作るメソッドを予呼ぶ。				

					SnmpTrapMasterLocal master=(SnmpTrapMasterLocal)masters.iterator().next();
								
					info.setMib(master.getMib());
					info.setTrapOid(master.getTrapOid());
					info.setGenericId(master.getGenericId().intValue());
					info.setSpecificId(master.getSpecificId().intValue());
					info.setUei(master.getUei());
					info.setLogmsg(master.getLogmsg());
					info.setDescr(master.getDescr());
					info.setPriority(master.getPriority());
	
					return info;
				
			}else if(masters.size() == 0 ){
				
				//検索の結果が０というので、未登録MIBを判定します。
				
				
				//判定条件はMIBがnull
				
				info.setTrapOid(trapOid);
				info.setMib(null);
				return info;
			}
			
		} catch (FinderException e) {
			m_log.error("findMasterInfo():" + e.getMessage());
			e.printStackTrace();
			
		} catch (NamingException e) {
			
			m_log.error("findMasterInfo():" + e.getMessage());
			e.printStackTrace();
		}
		
		return null;
		
	}
}
