/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.factory;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.RunMonitorStringValueType;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoPK;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;
import com.clustercontrol.sql.util.AccessDB;
import com.clustercontrol.util.Messages;

/**
 * SQL監視 文字列監視用実行クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class RunMonitorSqlString extends RunMonitorStringValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorSqlString.class );

	public static final String MESSAGE_ID_UNKNOWN = "100";
	
	/** SQL監視情報 */
	protected MonitorSqlInfoLocal m_sql = null;
	
	/** 接続文字列 */
	protected String m_url = null;
	
	/** ユーザ */
	protected String m_user = null;
	
	/** パスワード */
	protected String m_password = null;
	
	/** クエリ */
	protected String m_query = null;
	
	/** JDBCドライバ */
	protected String m_jdbcDriver = null;
	
	/** 不明メッセージ */
	protected String m_unKnownMessage = null;
	
	/** オリジナルメッセージ */
	protected String m_messageOrg = null;
	
	/**
	 * コンストラクタ
	 * 
	 */
	public RunMonitorSqlString() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * 監視実行
	 * 
	 * @param monitorTypeId 監視監視対象ID
	 * @param monitorId 監視項目ID
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws JMSException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	@Override
	public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, CreateException {
		
		m_monitorTypeId = monitorTypeId;
		m_monitorId = monitorId;
		
		m_now = new Date();
		
		try 
		{
			// 監視基本情報を設定
			boolean run = setMonitorInfo(m_monitorTypeId, m_monitorId);
			if(!run){
				// 処理終了
				return;
			}
			
			// 判定情報を設定
			setJudgementInfo();
			
			// 監視チェック情報を設定
			setCheckInfo();

			// 監視値を収集
			boolean ret = collect(null);

			// 監視値より判定結果を取得
			int checkResult = getCheckResult(ret);
			
			m_nodeDate = new Date().getTime();
			
			// 監視監視へ通知
			notify(true, m_facilityId, checkResult, new Date(m_nodeDate));

		} catch (FinderException e) {
            m_log.error("run():" + e.getMessage());
			throw e;
		} catch (JMSException e) {
			m_log.error("run():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.error("run():" + e.getMessage());
			throw e;
		} catch (CreateException e) {
			m_log.error("run():" + e.getMessage());
			throw e;
		}
		finally{
			// 終了処理
			this.terminate();
		}
	}

	/**
	 * SQL数を取得
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true
	 */
	@Override
	public boolean collect(String facilityId) {
		boolean result = false;
		
		AccessDB access = null;
		ResultSet rSet = null;
		try {
			// DB接続初期処理
			access = new AccessDB(
					m_jdbcDriver, 
					m_url, 
					m_user, 
					m_password);
			
			// SQL文を実行し、結果を取り出す。
        	if(m_query.length() >= 6){
        		String work = m_query.substring(0, 6);
    			if( work.equalsIgnoreCase("SELECT")){
    				rSet = access.read(m_query);

    				//1レコード目の1カラム目のデータを取得
    				rSet.first();
    				m_value = rSet.getString(1);
    				
    				//レコード件数を取得
    				rSet.last();
    				int number = rSet.getRow();
    				
    				NumberFormat numberFormat = NumberFormat.getNumberInstance();
    				m_messageOrg = Messages.getString("record.value") + " : " + m_value + ", " + 
    					Messages.getString("records.number") + " : " + numberFormat.format(number);

    				result = true;
    			}
    			else{
    				//SELECT文以外はエラー
    				m_log.debug("collect(): " + Messages.getString("message.sql.5"));
    				m_unKnownMessage = Messages.getString("message.sql.5");
    				m_messageOrg = Messages.getString("sql.string") + " : " + m_query;
    			}
        	}
        	else{
				//SELECT文以外はエラー
				m_log.debug("collect(): " + Messages.getString("message.sql.5"));
				m_unKnownMessage = Messages.getString("message.sql.5");
				m_messageOrg = Messages.getString("sql.string") + " : " + m_query;
			}
		} catch (ClassNotFoundException e) {
			m_unKnownMessage = Messages.getString("message.sql.6");
			m_messageOrg = Messages.getString("sql.string") + " : " + m_query + " (" + e.getMessage() + ")";
		} catch (SQLException e) {
			// SQL実行エラー
			m_unKnownMessage = Messages.getString("message.sql.7");
			m_messageOrg = Messages.getString("sql.string") + " : " + m_query + " (" + e.getMessage() + ")";
		} finally {
			try {
				if(rSet != null){
					rSet.close();
				}
				if(access != null){
					// DB接続終了処理
					access.terminate();
				}
			} catch (SQLException e) {
				m_log.error("collect(): ", e);
			}
		}
		return result;
	}
	
	/* (non-Javadoc)
	 * SQL監視情報を設定
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// SQL監視情報を取得
		MonitorSqlInfoPK pk = new MonitorSqlInfoPK(m_monitorId, m_monitorTypeId);
		m_sql = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// SQL監視情報を設定
		m_url = m_sql.getConnection_url().trim();
		m_user = m_sql.getConnection_user().trim();
		m_password = m_sql.getConnection_password().trim();
		m_query = m_sql.getQuery().trim();
		m_jdbcDriver = m_sql.getJdbc_driver().trim();
	}

	/* (非 Javadoc)
	 * ノード用メッセージIDを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {
		
		String messageId = super.getMessageId(id);
		if(messageId == null || "".equals(messageId)){
			return MESSAGE_ID_UNKNOWN;
		}
		return messageId;
	}
	
	/* (非 Javadoc)
	 * ノード用メッセージを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		
		String message = super.getMessage(id);
		if(message == null || "".equals(message)){
			return m_unKnownMessage;
		}
		return message;
	}

	/* (非 Javadoc)
	 * ノード用オリジナルメッセージを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
}
