/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.util.Date;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * OpenLDAP監視クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorLdap extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorLdap.class);
	
	/**
	 * 監視実行
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		boolean providerServer = false;
		boolean consumerServer = false;
		
		try {
			//プロバイダLDAP用のコンテキストの作成
			InitialContext iniCtx = new InitialContext();
			
			@SuppressWarnings("unused")
			DirContext dirCtx = 
				(InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/provider");
			
			providerServer = true;
			
		} catch (NamingException e) {
			log.error("run() : LDAP Connection Error : " + e.getMessage());
		}
		
		try {
			//コンシューマLDAP用のコンテキストの作成
			InitialContext iniCtx = new InitialContext();
			
			@SuppressWarnings("unused")
			DirContext dirCtx = 
				(InitialLdapContext)iniCtx.lookup("external/hinemos/ldap/consumer");
			
			consumerServer = true;
			
		} catch (NamingException e) {
			log.error("run() : LDAP Connection Error : " + e.getMessage());
		}
		
		//ログ出力
		logout(providerServer, consumerServer);
		
		log.debug("run() end :");
	}
	
	/**
	 * ログ出力
	 * 
	 * @param providerServer
	 * @param consumerServer
	 */
	protected void logout(boolean providerServer, boolean consumerServer) {
		
		String application = NotifyMessages.getString("ldap.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//プロバイダサーバ正常、コンシューマサーバ正常
		if(providerServer && consumerServer){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("LDAP01");
			//メッセージID
			info.setMessageId("001");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("ldap01.001.message"));
			String[] args = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.001.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.001.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//プロバイダサーバ異常、コンシューマサーバ正常
		else if(!providerServer && consumerServer){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("LDAP01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args1 = {this.troubleDetectionInfo.getLdapProvider()};
			info.setMessage(NotifyMessages.getString("ldap01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.002.org.message", args2));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//プロバイダサーバ正常、コンシューマサーバ異常
		else if(providerServer && !consumerServer){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("LDAP01");
			//メッセージID
			info.setMessageId("003");
			//メッセージ、オリジナルメッセージ
			String[] args1 = {this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessage(NotifyMessages.getString("ldap01.003.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.003.org.message", args2));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.003.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//プロバイダサーバ異常、コンシューマサーバ異常
		else if(!providerServer && !consumerServer){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("LDAP01");
			//メッセージID
			info.setMessageId("004");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("ldap01.004.message"));
			String[] args = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString("ldap01.004.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("ldap01.004.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * ログ出力
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("ldap.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//通知情報作成
		LogOutputInfo info = new LogOutputInfo();
		//プラグインID
		info.setPluginId(PLUGIN_ID);
		//アプリケーション
		info.setApplication(application);
		//監視項目ID
		info.setMonitorId(monitorId);
		//メッセージID
		info.setMessageId(messageId);
		//メッセージ、オリジナルメッセージ
		if(key.equals("ldap02.001")){
			info.setMessage(NotifyMessages.getString(key + ".message"));
			String[] args = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args));
		}
		else if(key.equals("ldap02.002")){
			String[] args1 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapProvider(), 
					this.troubleDetectionInfo.getLdapConsumer()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else if(key.equals("ldap03.001")){
			info.setMessage(NotifyMessages.getString(key + ".message"));
			String[] args = {this.troubleDetectionInfo.getLdapConsumer(), 
					this.troubleDetectionInfo.getLdapProvider()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args));
		}
		else if(key.equals("ldap03.002")){
			String[] args1 = {this.troubleDetectionInfo.getLdapConsumer(), 
					this.troubleDetectionInfo.getLdapProvider()};
			info.setMessage(NotifyMessages.getString(key + ".message", args1));
			String[] args2 = {this.troubleDetectionInfo.getLdapConsumer(), 
					this.troubleDetectionInfo.getLdapProvider()};
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message", args2));
		}
		else{
			info.setMessage(NotifyMessages.getString(key + ".message"));
			info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		}
		//ファシリティID
		info.setFacilityId(FACILITY_ID);
		//スコープ
		info.setScopeText("");
		//重要度
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//発生日時
		info.setGenerationDate(new Date());
		
		//ログ出力
		output.outputLog(notifyInfo, info);
	}
}
