/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * スコープ情報をツリー構造化するためのクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeItem implements Serializable {

    //	 ----- static フィールド ----- //

    /**
	 * 
	 */
	private static final long serialVersionUID = 1663475778653652044L;

	/** パスセパレーター */
    public static final String SEPARATOR = ">";

    //	 ----- instance フィールド ----- //

    /** 親 */
    private FacilityTreeItem parent = null;

    /** 情報オブジェクト */
    private FacilityInfo data = null;

    /** 子の格納リスト */
    private List childrens = null;

    // ----- コンストラクタ ----- //

    /**
     * 引数の情報を保持したインスタンスを返します。
     * 
     * @param parent
     *            親のオブジェクト
     * @param data
     *            スコープ情報オブジェクト
     */
    public FacilityTreeItem(FacilityTreeItem parent, FacilityInfo data) {

        this.setParent(parent);
        this.setData(data);

        if (parent != null) {
            parent.addChildren(this);
        }

        this.childrens = new ArrayList();
    }

    // ----- instance フィールド ----- //

    /**
     * 親を返します。
     * 
     * @return 親
     */
    public FacilityTreeItem getParent() {
        return this.parent;
    }

    /**
     * 親を設定します。
     * <p>
     * 
     * インスタンス化の際に親へ関係付けているため、子を削除するメソッドを実装した 後に可視性(スコープ)を拡大して下さい。 <br>
     * また、新しい親への関係付けも行うように実装して下さい。
     * 
     * @return 親
     */
    public void setParent(FacilityTreeItem parent) {
        this.parent = parent;
    }

    /**
     * スコープ情報を返します。
     * 
     * @return スコープ情報
     */
    public FacilityInfo getData() {
        return this.data;
    }

    /**
     * スコープ情報を設定します。
     * 
     * @param data
     *            スコープ情報
     */
    public void setData(FacilityInfo data) {
        this.data = data;
    }

    /**
     * 子を追加します。
     * <p>
     * 
     * この際、childeの親はこのオブジェクトとして設定されます。
     * 
     * @param child
     *            子
     */
    public void addChildren(FacilityTreeItem child) {
        child.setParent(this);
        childrens.add(child);
    }

    /**
     * 子の数を返します。
     * 
     * @return 子の数
     */
    public int size() {
        return childrens.size();
    }

    /**
     * 全ての子を返します。
     * <p>
     * 
     * 並び順は、追加された順となっています。
     * 
     * @return 全ての子。
     */
    public FacilityTreeItem[] getChildren() {
        FacilityTreeItem[] result = new FacilityTreeItem[this.size()];
        return (FacilityTreeItem[]) childrens.toArray(result);
    }
    /**
     * 直下のこどものデータがあれば消します。
     * 1つだけ消します。
     * 
     */
    public boolean removeChild(String facilityId){
    	
    	
    	for(int i=0 ; i< childrens.size(); i++){
    		
    		if(facilityId.equals(((FacilityTreeItem)childrens.get(i)).getData().getFacilityId())){
    			
    			//マッチした場合にはその要素を消します。
    			childrens.remove(i);
    			return true;
    		}
    	}
    	
		return false;
    }
    
    
}