/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view.action;

import java.util.Date;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.bean.WeekdayListTableDefine;
import com.clustercontrol.calendar.dialog.WeekdayInfoDialog;
import com.clustercontrol.calendar.view.WeekdayInfoListView;

/**
 * カレンダ追加情報の作成・変更ダイアログによる、カレンダ追加情報の変更を行うアクションクラスです。
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class WeekdayInfoModifyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.WeekdayInfoModifyAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        //カレンダIDを取得
        WeekdayInfoListView view = 
        	(WeekdayInfoListView)this.viewPart.getAdapter(WeekdayInfoListView.class);
        String calendarId = view.getComposite().getCalendarId();

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        Integer weekday = null;
        Date from = null;
        Date to = null;
        if (list != null) {
        	weekday = (Integer)list.get(WeekdayListTableDefine.WEEKDAY);
        	from = (Date)list.get(WeekdayListTableDefine.TIME_FROM);
        	to = (Date)list.get(WeekdayListTableDefine.TIME_TO);
        }

        if (calendarId != null & weekday != null & from != null & to != null) {
            // ダイアログを生成
        	WeekdayInfoDialog dialog = new WeekdayInfoDialog(this.viewPart
                    .getSite().getShell(), calendarId, weekday, from, to, PropertyConstant.MODE_MODIFY);

            // ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
            if (dialog.open() == IDialogConstants.OK_ID) {
                view.update(calendarId);
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}