/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * ジョブ通知マスタのBMP Entity Beanです。
 * 
 * @ejb.bean name="JobNoticeMaster"
 *           jndi-name="JobNoticeMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl
 */
public abstract class JobNoticeMasterBean implements javax.ejb.EntityBean {
    /** ジョブID */
    protected String job_id;
    /** 終了状態 */
    protected Integer notice_type;
    /** 重要度 */
    protected Integer priority;
    /** 通知ID */
    protected String notify_id;
    
    /**
     * ジョブ通知マスタを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param job_id ジョブID
     * @param notice_type 終了状態
     * @param priority 重要度
     * @param notify_id 通知ID
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.EndStatusConstant
     * @see com.clustercontrol.bean.PriorityConstant
     */
    public JobNoticeMasterPK ejbCreate(
            String job_id, 
            Integer notice_type, 
            Integer priority, 
            String notify_id
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.notice_type = notice_type;
        this.priority = priority;
        this.notify_id = notify_id;
        return null;
    }

	/**
	 * 全てのジョブ通知マスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ通知マスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl#findByPrimaryKey(JobNoticeMasterPK)
	 */
	public JobNoticeMasterPK ejbFindByPrimaryKey(JobNoticeMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブIDに一致するジョブ通知マスタを検索します。
	 * 
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl#findByJobId(String)
	 */
	public Collection ejbFindByJobId(String job_id) throws FinderException {
		return null;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

	/**
	 * 終了状態を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
    public java.lang.Integer getNotice_type() {
    	return notice_type;
    }

	/**
	 * 終了状態を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notice_type 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
    public void setNotice_type(java.lang.Integer notice_type) {
    	this.notice_type = notice_type;
    }

	/**
	 * 重要度を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public java.lang.Integer getPriority() {
    	return priority;
    }

	/**
	 * 重要度を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public void setPriority(java.lang.Integer priority) {
    	this.priority = priority;
    }

	/**
	 * 通知IDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
    public java.lang.String getNotify_id() {
    	return notify_id;
    }

	/**
	 * 通知IDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notify_id 通知ID
	 */
    public void setNotify_id(java.lang.String notify_id) {
    	this.notify_id = notify_id;
    }
    
	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
    public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
    
    

}
