/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl;


/**
 * ジョブリレーションマスタのBMP Entity Beanです。
 * 
 * @ejb.bean name="JobRelationMaster"
 *           jndi-name="JobRelationMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobRelationMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl
 */
public abstract class JobRelationMasterBean implements javax.ejb.EntityBean {
    /** ジョブID */
    protected String job_id;
    /** 親ジョブID */
    protected String parent_job_id;
    
    /**
     * ジョブリレーションマスタを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param job_id ジョブID
     * @param parent_job_id 親ジョブID
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     */
    public JobRelationMasterPK ejbCreate(
            String job_id, 
            String parent_job_id
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.parent_job_id = parent_job_id;
        return null;
    }
    
	/**
	 * 全てのジョブリレーションマスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブリレーションマスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findByPrimaryKey(JobRelationMasterPK)
	 */
	public JobRelationMasterPK ejbFindByPrimaryKey(JobRelationMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * 親ジョブIDが一致するジョブリレーションマスタを検索します。
	 * 
	 * @param parent_job_id 親ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findByParentJobId(String)
	 */
	public Collection ejbFindByParentJobId(java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブIDが一致するジョブリレーションマスタを検索します。
	 * 
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl#findByJobId(String)
	 */
	public JobRelationMasterPK ejbFindByJobId(java.lang.String job_id) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

	/**
	 * 親ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getParent_job_id() {
    	return parent_job_id;
    }

	/**
	 * 親ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param parent_job_id 親ジョブID
	 */
    public void setParent_job_id(java.lang.String parent_job_id) {
    	this.parent_job_id = parent_job_id;
    }
    
	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
	
	
    /**
     * 引数で指定されたジョブIDの子のジョブIDのリストを返します。
     * 
     * @ejb.home-method view-type="local"
     * 
     * @param jobId ジョブID
     * @return ジョブIDのコレクション
     * @throws javax.ejb.FinderException
     */
    public Collection ejbHomeGetJobsList(String jobId) throws javax.ejb.FinderException{

    	
    	JobRelationMasterDAOImpl jrmDAO = new JobRelationMasterDAOImpl();
    	
    	
    	return jrmDAO.getJobsList(jobId);
    }
	
    /**
     * 引数で指定されたジョブIDの最上位のジョブIDを返します。
     * 
     * @ejb.home-method view-type="local"
     * 
     * @param jobId ジョブID
     * @return 最上位のジョブID
     * @throws javax.ejb.FinderException
     */
    public String ejbHomeGetTopJobId(String jobId) throws javax.ejb.FinderException{

    	
    	JobRelationMasterDAOImpl jrmDAO = new JobRelationMasterDAOImpl();
    	
    	
    	return jrmDAO.getTopJobId(jobId);
    }
}
