/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logagent.util;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.ejb.session.RepositoryControllerHome;


/**
 * EJBとのコネクションを管理するクラス
 * RepositoryController　EJBを呼び出すためのヘルパ
 * @version 2.0.0
 * @since 2.0.0
 */
public class EjbConnectionManager {
    
	private Properties m_props = null;

	private NamingContext m_con = null;

	//ロガー
	static private Log log = LogFactory.getLog(EjbConnectionManager.class);

	/**
	 * コンストラクタ
	 * @param prop　プロパティファイル情報
	 */
	public EjbConnectionManager(Properties prop) {
		m_props = prop;
	}
	
	/**
	 * RepositoryCollectorを取得します。
	 * @return　RepositoryCollector
	 * @throws NamingException 
	 * @throws RemoteException 
	 * @throws CreateException 
	 */
	public synchronized RepositoryController getRepositoryController() throws Exception {

		try {
			if(m_con != null)
				LoginManager.getContextManager(m_props).logout();
			m_con = LoginManager.getContextManager(m_props).getNamingContext();
			
			RepositoryControllerHome home = (RepositoryControllerHome) m_con
		    	.lookup(RepositoryControllerHome.JNDI_NAME);
			return home.create();
		} catch (Exception e) {
			LoginManager.getContextManager(m_props).logout();
			m_con = null;
			throw e;
		}
	}
}
