/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.monitor.ejb.entity.StatusInfoLocal;
import com.clustercontrol.monitor.ejb.entity.StatusInfoUtil;
import com.clustercontrol.util.Messages;

/**
 * ステータス情報を管理するクラスです。
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class ManageStatus {

	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( ManageStatus.class );

	/**
	 * 存続期間を経過したステータス情報を削除 または 更新します。
	 * <p>
	 * <ol>
	 *  <li>存続期間を経過したステータス情報を取得します。
	 *  <li>取得したステータス情報の存続期間経過後の処理の制御フラグを確認します。
	 *  <li>制御フラグ（{@link com.clustercontrol.bean.StatusExpirationConstant}）が削除の場合は、ステータス情報を削除します。<BR>
	 *      重要度の場合は、ステータス情報を更新します。更新する項目は、下記の通りです。
	 *      <ul>
	 *       <li>重要度
	 *       <li>メッセージID（空白）
	 *       <li>メッセージ
	 *       <li>最終変更日時
	 *       <li>存続期間経過後の処理の制御フラグ（期限切れ）
	 *      </ul>
	 * </ol>
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public void execute(){
		
		Collection ct = null;
		try 
		{
			// 有効期限切れのステータス情報一覧を取得
			ct = StatusInfoUtil.getLocalHome().findExpirationStatus(new Timestamp(new Date().getTime()));
			
		} catch (FinderException e) {
            m_log.error("execute():" + e.getMessage());
		} catch (NamingException e) {
            m_log.error("execute():" + e.getMessage());
		}
		
		if(ct != null){
			Timestamp now = new Timestamp(new Date().getTime());
			
			Iterator itr = ct.iterator();
			StatusInfoLocal status = null;
			while(itr.hasNext())
			{
				try{
					status = (StatusInfoLocal)itr.next();
					if(status.getExpirationFlg() != null){
						int flg = status.getExpirationFlg().intValue();
						
						// 削除
						if(StatusExpirationConstant.TYPE_DELETE == flg){
							status.remove();
						}
						// 更新されていない旨のメッセージに置換える
						else if(StatusExpirationConstant.TYPE_CRITICAL == flg || 
								StatusExpirationConstant.TYPE_WARNING == flg ||
								StatusExpirationConstant.TYPE_INFO == flg ||
								StatusExpirationConstant.TYPE_UNKNOWN == flg){
							// メッセージIDを空白にする
							status.setMessageId("");
							// 重要度の設定
							status.setPriority(new Integer(flg));
							// メッセージに更新されていない旨のメッセージを設定
							status.setMessage(Messages.getString("monitor.status.no.update"));
							// 有効期限切れ制御フラグに有効期限切れを設定
							status.setExpirationFlg(StatusExpirationConstant.TYPE_EXPIRATION);
							// 更新日時を設定
							status.setOutputDate(now);
						}
					}
				} catch (RemoveException e) {
					m_log.error("execute():" + status == null ? "":(status.getFacilityId() + "," + status.getMonitorId() + "," + status.getPluginId() + ",") + e.getMessage());
				} catch (EJBException e) {
					m_log.error("execute():" + status == null ? "":(status.getFacilityId() + "," + status.getMonitorId() + "," + status.getPluginId() + ",") + e.getMessage());
				}
			}
		}
	}
}