/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoUtil;

/**
 * 数値監視の判定情報を作成する抽象クラスです。
 * <p>
 * 数値監視を行う各監視管理クラスで継承してください。
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class AddMonitorNumericValueType extends AddMonitor{
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( AddMonitorNumericValueType.class );
	
	/**
	 * 数値監視の判定情報を作成し、監視情報に設定します。
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoBean
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean addJudgementInfo() throws CreateException, NamingException {
		
		Collection ct = m_monitor.getMonitorNumericValueInfo();
		
		ArrayList valueList = m_monitorInfo.getJudgementInfo();
		ArrayList<MonitorNumericValueInfoLocal> valueLocalList = new ArrayList<MonitorNumericValueInfoLocal>();
		
		// 数値監視判定情報を設定
		MonitorNumericValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorNumericValueInfo)valueList.get(index);
			if(value != null){
				MonitorNumericValueInfoLocal local = MonitorNumericValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						Integer.valueOf(value.getPriority()),
						Double.valueOf(value.getThresholdUpperLimit()),
						Double.valueOf(value.getThresholdLowerLimit()),
						value.getMessageId(),
						value.getMessage(),
						Integer.valueOf(value.getJobRun()),
						value.getJobId(),
						Integer.valueOf(value.getJobInhibitionFlg()),
						Integer.valueOf(value.getJobFailurePriority()));
				valueLocalList.add(local);
			}
		}
		ct.addAll(valueLocalList);
		m_monitor.setMonitorNumericValueInfo(ct);
		
		return true;
	}
}
