/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.util;

import java.util.Date;
import java.util.Iterator;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import com.clustercontrol.performance.action.RealtimeController;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performanceMGR.bean.CollectedDataInfo;

/**
 * リアルタイム表示を行うときに定期的に値を収集するスレッドクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeCollectThread extends Thread {

    private TimeSeries[] m_timeseries;
    
    private int interval;
    
    private int requestInterval;
    
    private RealtimeController clientRealTimeController;

    private CollectedDataInfo dataInfo;

    private String facilityID;

	private String itemCode;

	private String itemId;

	private int deviceIndex;
	
	private String deviceName;
	
	private String displayType;
    
	private Date timestamp;
	private int collectTimestampId;
	private RealtimeCollectorInfo collectorInfo = null;
	private RealtimeGraphComposite graphComposite = null;
    /**
     * コンストラクター
     * 
     * @param facilityID
     */
    public RealtimeCollectThread(
    			Date timestamp,
    			int collectTimestampId,
	         	TimeSeries[] m_timeseries,
    			String itemCode,
    			String itemId,
    			int deviceIndex,
    			String deviceName,
    			String displayType,
    			int interval,
    			int requestInterval,
    			String facilityID,
    			boolean check,
    			RealtimeGraphComposite graphComposite) {
    	
    	if (timestamp != null) {
        	this.timestamp = timestamp;
    	}
    	if (collectTimestampId >= 0) {
        	this.collectTimestampId = collectTimestampId;
    	} 
    	if (m_timeseries != null) {
            this.m_timeseries = m_timeseries;
    	}
    	if (itemCode != null) {
            this.itemCode = itemCode;
    	} 

    	this.deviceIndex = deviceIndex;
    	
    	this.deviceName = deviceName;

    	if (displayType != null) {
            this.displayType = displayType;
    	}
    	if (itemId != null) {
            this.itemId = itemId;
    	}
    	if (interval >= 0) {
            this.interval = interval;
    	}
    	if (requestInterval >= 0) {
            this.requestInterval = requestInterval;
    	}
    	if (facilityID != null) {
            this.facilityID = facilityID;
    	}
    	if (graphComposite != null) {
            this.graphComposite = graphComposite;
    	}
    	
        // シングルトンでオブジェクトを作成したがコメントアウトした.
      this.clientRealTimeController = RealtimeController.getInstance();
    }

    public void run() {
    	clientRealTimeController.setCollectorInfo(collectorInfo);
    	
    	clientRealTimeController.startCollect(
    			timestamp,
    			collectTimestampId,
    			interval, requestInterval, this, itemCode, itemId, deviceIndex, deviceName, displayType,
    			// falseは意味なし。
    			facilityID, false,graphComposite); 
    }

    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
    	this.collectorInfo = collectorInfo;
    }
    
    public void setGraph() {
    	if (graphComposite == null) {
    	}
    	graphComposite.setValueaxisRange(collectorInfo.getGraphPlotNum(),interval);
    }
    
    
    public boolean setDataList(Iterator itr, String displayType) {
	    // 初期バージョンでは、ファシリティIDがソートされていない場合に配慮し、
	    // 逐一チェックしてセットしていた。
	    // 本バージョンでは、ファシリティIDがソートされていることを前堤とした処理方式に変更している。
    	boolean isRun =true;
		double graphLineValue = 0.0D;
		double sumOfDataInfoValueSum = 0.0D;
		int graphLineNum = m_timeseries.length; // 本来は値の箇数から算出すべき.itrなので暫定対処.
		
		// itrだと詳細値生成のため逆からデータを取得できず不便.一旦配列に入れる.
		double[] collectedValue = new double[graphLineNum];
		Date[] graphLineDate = new Date[graphLineNum];
		
		int i = 0;	// itrを使ってint i=0でカウンタを用いるのはおかしい。素直に配列にすべき.
		while (itr.hasNext()) {
	    	dataInfo = (CollectedDataInfo) itr.next();
	    	collectedValue[i] = dataInfo.getValue();
	    	graphLineDate[i] = dataInfo.getDate();
	    	
		    i++;
	    }
		
		for (int j=0;j < graphLineNum; j++) {
			if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
				graphLineValue = collectedValue[graphLineNum-j-1]; 
			} else if (displayType.equals("Detail")) {
				graphLineValue = sumOfDataInfoValueSum + collectedValue[graphLineNum-j-1];
				sumOfDataInfoValueSum = graphLineValue;
			}
			// グラフが切り替えられてm_timeseriesが消された場合は処理を停止する。(未実装)
			if (m_timeseries != null) {
	            if (!Double.isNaN(graphLineValue)) {
	            	m_timeseries[graphLineNum-j-1].addOrUpdate(new Second(graphLineDate[graphLineNum-j-1]),graphLineValue);
	            }
			} else {
				isRun =false;
			}
		}
		return isRun;
    }
}