/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol;

import java.util.Hashtable;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.ejb.session.JobRunManagement;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementHome;

/**
 * ジョブ用Quartz設定クラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobSetup {
    public static final String QUARTZ_NAME = "Quartz";
    
    /**
     * メイン
     * 
     * @param args
     */
    public static void main(String[] args) {
        JobSetup setup = new JobSetup();
        try {
            setup.setup(args);
        } catch (Exception e) {
        }
    }

    /**
     * Quartzへ登録
     * @param args
     */
    public void setup(String[] args) throws Exception {
        if(args.length != 2 && args.length != 3){
            return;
        }
        
        //QuartzのSchedulerをルックアップ
        InitialContext context = getContext("jnp://" + args[1]);
        JobRunManagementHome home = 
            (JobRunManagementHome)context.lookup(JobRunManagementHome.JNDI_NAME);
        
        JobRunManagement runManagemant = home.create();
        
        if(args[0].compareTo("add") == 0){
	        runManagemant.addQuartz(args[2]);
        }
        else if(args[0].compareTo("del") == 0){
            runManagemant.deleteQuartz();
        }
    }
    
    /**
     * InitialContext作成
     * 
     * @return
     * @throws NamingException
     */
    private InitialContext getContext(String url) throws NamingException {
        Hashtable props = new Hashtable();
        
        props.put(InitialContext.INITIAL_CONTEXT_FACTORY, 
                "org.jnp.interfaces.NamingContextFactory");
        props.put(InitialContext.PROVIDER_URL, 
                url);

        InitialContext initialContext = new InitialContext(props);
        return initialContext;
    }
}
