/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpNoSuchInstance;
import org.opennms.protocols.snmp.SnmpNoSuchObject;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpV2Error;
import org.opennms.protocols.snmp.SnmpVarBind;



/**
 * SNMP�Υݡ���󥰤�¹Ԥ��륯�饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class SnmpPoller implements SnmpHandler {
	protected static Log m_log = LogFactory.getLog( SnmpPoller.class );
	
	private String m_ipAddress;
	private String m_oidText;
	private SnmpObjectId m_startOid;
	private SnmpObjectId m_stopOid;
	private DataTable m_dataTable;
    private String m_message = null;
	boolean m_waitFlg;
    String lastOid;
    private int m_errorCode = 0;
	private final int Normal = 0;
	private final int TimeOutError = 1;
	private final int InternalError = 2; 
	
	/**
	 * ポーリングします。
	 * @param ipAddress
	 * @param port
	 * @param version
	 * @param community
	 * @param retries
	 * @param timeout
	 * @param oidList
	 * @param table　戻り値
	 */
	public void polling (
			InetAddress ipAddress, 
			int port,
			int version,
			String community,
			int retries,
			int timeout,
			List oidList,
			DataTable table)
	{
		// �ǥХå�����
		if(m_log.isDebugEnabled()){
		m_log.debug("polling() start :" + ipAddress.toString());
			m_log.debug("Port      : " + port);
			m_log.debug("Version   : " + version);
			m_log.debug("Community : " + community);
			m_log.debug("Retries   : " + retries);
			m_log.debug("Timeout   : " + timeout);
		}

		m_errorCode = Normal;
		m_dataTable = table;
		
		m_ipAddress = ipAddress.toString();
		
		SnmpPeer peer = new SnmpPeer(ipAddress);
		if(port != -1)
			peer.setPort(port);
		
		if(timeout != -1)
			peer.setTimeout(timeout);
		
		if(retries != -1)
			peer.setRetries(retries);
		
		//
		// Initialize the peer
		//
		SnmpParameters parms = peer.getParameters();
		parms.setVersion(version);
		if(community != null)
			parms.setReadCommunity(community);
		
		//
		// Now create the session, set the initial request
		// and walk the tree!
		//
		SnmpSession session = null;
		try
		{
			session = new SnmpSession(peer);
		}
		catch(SocketException e)
		{
			m_log.error("polling() warning  :" + ipAddress.toString()
					+ " SocketException creating the SNMP session");
			m_errorCode = InternalError;
			return;
		}
		
		session.setDefaultHandler(this);

		try
		{
			Iterator itr = oidList.iterator();
			
			while(itr.hasNext()){
				m_oidText = (String)itr.next();
				m_startOid = new SnmpObjectId(m_oidText);
				
		        //
		        // set the stop point
		        //
		        SnmpObjectId id = new SnmpObjectId(m_oidText);
		        
		        int[] ids = id.getIdentifiers();
		        ++ids[ids.length - 1];
		        id.setIdentifiers(ids);
		        m_stopOid = id;			
				
				// build the first request
//				SnmpPduRequest pdu = new SnmpPduRequest(SnmpPduRequest.GET);
				SnmpPduRequest pdu = new SnmpPduRequest(m_oidText.endsWith(".0") ? SnmpPduPacket.GET : SnmpPduPacket.GETNEXT);
				pdu.setRequestId(SnmpPduPacket.nextSequence());
				
				SnmpObjectId oId = new SnmpObjectId(m_oidText);
				pdu.addVarBind(new SnmpVarBind(oId));
				
				synchronized(session)
				{
					m_waitFlg = true;
					session.send(pdu);
					
					if(m_waitFlg){
					session.wait();
				}
			}
		}
		}
		catch(InterruptedException e) 
		{ 
			m_log.error("polling() warning :" + ipAddress.toString()
					+ " polling failed at InterruptedException" );
			m_errorCode = InternalError;
			return;
		}
		finally
		{
			session.close();
		}
		
		// �㳰����(̤����)
		if(this.m_errorCode == TimeOutError){
			
		} else if (this.m_errorCode == InternalError){

		}
		
		// �ǥХå�����
		if(m_log.isDebugEnabled()){
		m_log.debug("polling() end :" + ipAddress.toString());
	}
	}
	
	public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
//		m_log.debug("snmpReceivedPdu() start");

		try{
			long time = System.currentTimeMillis();   // ���;���
			
			SnmpPduRequest req = null;
			if(pdu instanceof SnmpPduRequest) {
				req = (SnmpPduRequest)pdu;
			} else {
				m_log.error("polling() error :" +  session.toString() + " Received non-request pdu");
				synchronized(session)
				{
					m_errorCode = InternalError;
					session.notify();
				}
				return;
			}
			
			if(pdu.getCommand() != SnmpPduPacket.RESPONSE)
			{
				m_log.error("polling() error :" +  session.toString() + "  Received non-response command " + pdu.getCommand());
				synchronized(session)
				{
					m_errorCode = InternalError;
					session.notify();
				}
				return;
			}
			
//			SnmpVarBind[] vars = pdu.toVarBindArray();
			
			if(req.getErrorStatus() != 0)
			{
				m_log.error("polling() error :" +  session.toString() + "  Error Status " + req.getErrorStatus());
				synchronized(session)
				{
					m_errorCode = InternalError;
					session.notify();
				}
				return;
			}
            SnmpVarBind var = pdu.getVarBindAt(0);
			

	        if (var.getValue().typeId() == SnmpEndOfMibView.ASNTYPE
	                || (m_stopOid != null && m_stopOid.compare(var.getName()) < 0))
	        {
	        	
                 synchronized (session)

	            {
	            	session.notify();
	            }
	            return;
	        }			
	        
	        //
	        // next pdu
	        //
	        SnmpPduRequest nxt = new SnmpPduRequest(SnmpPduPacket.GETNEXT);
	        nxt.setRequestId(SnmpPduPacket.nextSequence());
	        
	        // �ǥХå�����
	        if(m_log.isDebugEnabled()){
	        	m_log.debug(
	        			m_ipAddress +
	        			" " + var.getName().toString() + 
	        			" " + time +
	        			" " + var.getValue().getClass().getName() + 
	        			" " + var.getValue().toString()
	        	);
	        }
	        
	        if(m_startOid.isRootOf(var.getName())) {
	        	if(var.getValue() instanceof SnmpNoSuchInstance){
	        	}
	        	else if(var.getValue() instanceof SnmpNoSuchObject){
	        	}
	        	else if(var.getValue() instanceof SnmpV2Error){
		        	}
	        	else if(var.getValue() instanceof SnmpNull){
	        	}
	        	else if(var.getValue() instanceof SnmpTimeTicks){
	        		// �ǥХå�
	        		if(m_log.isDebugEnabled()){
	        			m_log.debug(
	        					m_ipAddress + "," +
	        					var.getName().toString() + "," + time + "," + var.getValue().toString()
	        			);
	        		}
	        		
	        		long i = ((SnmpUInt32)var.getValue()).getValue();
	        		m_dataTable.putValue(var.getName().toString(), time, String.valueOf(i));
	        	}
	        	else{
	        		// �ǥХå�
	        		if(m_log.isDebugEnabled()){
	        			m_log.debug(
	        					m_ipAddress + "," +
	        					var.getName().toString() + "," + time + "," + var.getValue().toString()
	        			);
	        		}
	        		
	        		m_dataTable.putValue(var.getName().toString(), time, var.getValue().toString());
	        	}
	        	
	        	nxt.addVarBind(new SnmpVarBind(var.getName()));	
	        }
	        
	        if(nxt.getLength() != 0){
//				m_log.debug("session.send() start");
				session.send(nxt, this);
			} else {
				synchronized(session)
				{
					session.notify();
				}
				return;
			}
		} catch (Exception e) {
				
			m_log.error(e);
//			e.printStackTrace();
			
			// ���λ���ޤ�
			synchronized(session)
			{
				m_errorCode = InternalError;
				session.notify();
			}
		}
	}
	
	/* (�� Javadoc)
	 * @see org.opennms.protocols.snmp.SnmpHandler#snmpInternalError(org.opennms.protocols.snmp.SnmpSession, int, org.opennms.protocols.snmp.SnmpSyntax)
	 */
	public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
		m_log.warn("snmpInternalError():" + session.toString()
				+ " snmpInternalError. The error code is " + err);
		
		synchronized(session)
		{
			m_errorCode = InternalError;
			m_message = "InternalError. The error code is " + err
				+ ". IP:" + m_ipAddress + " OID:" + m_oidText;
				removeTableValue();
			
			m_waitFlg = false;
			session.notify();
		}
	}
	
	/* (�� Javadoc)
	 * @see org.opennms.protocols.snmp.SnmpHandler#snmpTimeoutError(org.opennms.protocols.snmp.SnmpSession, org.opennms.protocols.snmp.SnmpSyntax)
	 */
	public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
		m_log.warn("snmpTimeoutError():" + session.getPeer().getPeer().toString()
				+ " " + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName()
				+ " polling failed at TimeoutError" );
		
		synchronized(session)
		{
			m_errorCode = TimeOutError;
			m_message = "TimeoutError." + " IP:" + session.getPeer().getPeer().toString()
				+ " OID:" + ((SnmpPduRequest)pdu).toVarBindArray()[0].getName();
	removeTableValue();
			
			session.notify();
		}
	}

	private void removeTableValue() {
		Iterator itr = m_dataTable.keySet().iterator();
		
		while(itr.hasNext()){
			String fullOid = (String)itr.next();
			if(fullOid.startsWith(m_oidText)){
				// �ơ��֥�˳�Ǽ����Ƥ����ͤ���
				m_dataTable.removeValue(fullOid);
			}
		}
	}
}
