package com.clustercontrol.snmptrap.ejb.mdb;

import java.util.ArrayList;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.repository.bean.FacilityTreeAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.factory.SelectMonitorInfo;
import com.clustercontrol.snmptrap.factory.TrapSnmpManager;
import com.clustercontrol.snmptrap.message.SnmpTrapMessageInfo;
import com.clustercontrol.util.Messages;
/**
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>LogOutputBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="NotifySnmpTrapBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/SnmpTrap/SnmpTrapNotify"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * 
 * @jboss.container-configuration
 *  name="Singleton Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/SnmpTrap/SnmpTrapNotify"
 * @jboss.destination-jndi-name name="queue/clustercontrol/SnmpTrap/SnmpTrapNotify"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated          
 */
public class NotifySnmpTrapBean implements MessageDrivenBean, MessageListener {
	
	protected static Log m_log = LogFactory.getLog( NotifySnmpTrapBean.class );
	
	/** 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * The context for the message-driven bean, set by the EJB container. 
	 * @generated
	 */
	private javax.ejb.MessageDrivenContext messageContext = null;
	
	/** 
	 * Required method for container to set context.
	 * @generated 
	 */
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}
	
	/** 
	 * Required creation method for message-driven beans. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition -->
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition -->
	 * @generated
	 */
	public void ejbCreate() {
		//no specific action required for message-driven beans 
	}
	
	/** 
	 * Required removal method for message-driven beans. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void ejbRemove() {
		messageContext = null;
	}
	
	/** 
	 * This method implements the business logic for the EJB. 
	 * 
	 * <p>Make sure that the business logic accounts for asynchronous message processing. 
	 * For example, it cannot be assumed that the EJB receives messages in the order they were 
	 * sent by the client. Instance pooling within the container means that messages are not 
	 * received or processed in a sequential order, although individual onMessage() calls to 
	 * a given message-driven bean instance are serialized. 
	 * 
	 * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
	 * of type javax.jms.Message. The throws clause (if used) must not include an application 
	 * exception. Must not be declared as final or static. 
	 *
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void onMessage(Message message) {
		m_log.debug("onMessage() : strat" );
		if(message instanceof ObjectMessage){
			ObjectMessage objectMessage = (ObjectMessage)message;
			
			Object obj = null;
			try {
				obj = objectMessage.getObject();
			} catch (JMSException e) {
			//	m_log.error("onMessage() : 受信メッセージが不正。" + e.getMessage());
				return;
			}
			
			if(obj instanceof SnmpTrapMessageInfo){
				
				
				RepositoryControllerLocal repository = null;
				
				try{
					
					// レポジトリ
					repository = RepositoryControllerUtil.getLocalHome().create();
					
					// SNMPTRAP通知情報
					SnmpTrapMessageInfo info = (SnmpTrapMessageInfo)obj;
					String monitorId = info.getMonitorId();
					String facilityId = info.getFacilityId();
					String facilityPath ;
					//Unregisteredスコープの場合には、IPアドレスを入れる。
					if(info.getFacilityId().equals(FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE)){
						facilityPath = info.getAgentAdder();
					}else{
						facilityPath = repository.getFacilityPath(facilityId, null);
					}
					
					String trapOid = info.getTrapOid();
					int genericId = info.getGenericId();
					int specificId = info.getSpecificId();
					
					SelectMonitorInfo select = new SelectMonitorInfo();
					MonitorSnmpTrapInfo snmpTrapInfo = select.getMonitorInfo(monitorId);
					
					
					//この後メッセージ送信時に使う変数軍
					//指定OIDではカスタマイズ可能であるため、この３つは個別に
					//変更する。
					String msg ;
					String msgOrg;
					int priority;
					
					
					if(snmpTrapInfo.getCheckMode() == MonitorSnmpTrapInfo.ALL_OID){
						//マスター登録OIDすべての場合
						// trapOid, genericId,specificIdを元にマスターテーブルに問い合わせを行う。
						
						SnmpTrapMasterInfo master = select.findMasterInfo(trapOid,genericId,specificId);
						
					
						//問い合わせた結果が１つであれば、イベントを生成する処理を行う。		
						if(master != null && master.getMib() != null){
							
							//指定OID監視の場合には以下の３つの要素がカスタマイズ可能だが、
							//マスター登録OIDすべての場合にはその値もマスターから取得する。
							
							msg    = master.getLogmsg();
							msgOrg = master.getDescr();
							priority = master.getPriority();
							
							//メッセージ送信へ
							sendMassage( msg, msgOrg, info, master, priority,
									snmpTrapInfo,  facilityPath);
						}
						
					}else if(snmpTrapInfo.getCheckMode() == MonitorSnmpTrapInfo.UNREGISTERED_OID){
						
						//マスター未登録OIDの場合
						// trapOid, genericId,specificIdを元にマスターテーブルに問い合わせを行う。
						
						SnmpTrapMasterInfo master = select.findMasterInfo(trapOid,genericId,specificId);
						
//						問い合わせた結果が0であれば、イベントを生成する処理を行う。						
						if(master != null && master.getMib() == null){
							
							
							//指定OID監視の場合には以下の３つの要素がカスタマイズ可能だが、
							//未登録MOIDの場合にはメッセージがない。重要度は常に不明
							
							msg    = "oid  : " + trapOid + " specificId : " + specificId +" generic_id : " + genericId;
							msgOrg =  "";
							priority = 1; // 重要度1は不明
							
							//メッセージ送信へ
							sendMassage( msg, msgOrg, info, master,  priority,
									snmpTrapInfo,  facilityPath);
							
						}
						
					}else{
						//m_log.error("onMessage() : incoming messages : " + snmpTrapInfo.getCheckMode());
						
						//指定OIDを監視する場合
						//
						ArrayList<MonitorSnmpTrapOidInfo> oidList = snmpTrapInfo.getOidInfos();
						
						for (int i = 0; i < oidList.size(); i++) {
							MonitorSnmpTrapOidInfo oidInfo = oidList.get(i);
							
							m_log.debug("oidInfo : " + oidInfo.getGenericId() + " " + oidInfo.getTrapOid() + " " + oidInfo.getSpecificId());
							// OIDが同一か
							if(trapOid.equals(oidInfo.getTrapOid())){
								// Generic IDが同一か
								if(genericId == oidInfo.getGenericId()){
									// Specific IDが同一か
									if(specificId == oidInfo.getSpecificId()){
										
										String mib = oidInfo.getMib();
										priority = oidInfo.getPriority();
										msg = oidInfo.getLogmsg();
										msgOrg = oidInfo.getDescr();
										
										// マスタ情報取得
										SnmpTrapMasterPK pk = new SnmpTrapMasterPK(										
												mib,
												trapOid,
												genericId,
												specificId);
										SnmpTrapMasterInfo master = select.getMasterInfo(pk);
										
										//メッセージ送信へ
										sendMassage( msg, msgOrg, info, master, priority,
												snmpTrapInfo,  facilityPath);
										
										
									}
								}
							}
						}
					}
				}
				catch(EJBException e){
					//m_log.error("onMessage():" + e.getMessage());
				}
				catch(Exception e){
					//m_log.error("onMessage():" + e.getMessage());
				}
				finally{
					if(repository != null){
						try {
							repository.remove();
						} catch (Exception e) {
					//		m_log.error("onMessage() : エラー" + e.getMessage());
						}
					}
					repository = null;
				}
			}
			else{
				m_log.debug("onMessage(): ObjectMessage is not an expected instance. " + obj.toString());
			}
		}
	}
	
	
	/**
	 * メッセージを詰めて送信するメソッド
	 * * （長いのでOnMessageから分割）
	 * @param msg イベントを生成する時のメッセージ（）
	 * @param msgOrg イベントを生成する際のオリジナルメッセージ
	 * @param info 受信したトラップ情報
	 * @param master　受信情報に対応するマスターのSNMPトラップ情報
	 * @param monitorId マッチしたMonitorID
	 * @param priority イベントの設定される重要度
	 * @param snmpTrapInfo MonitorIdに対応する監視設定除法
	 * @param facilityId マッチしたファシリティID
	 * @param facilityPath ファシリティ名
	 * @param trapOid　受信したトラップのOID
	 */
	private void sendMassage(String msg, 
			String msgOrg, 
			SnmpTrapMessageInfo info,
			SnmpTrapMasterInfo master,
			int priority,
			MonitorSnmpTrapInfo snmpTrapInfo,
			
			String facilityPath
	){
		
		m_log.debug("sendMassage() start:" + info.getMonitorId() + " " + info.getFacilityId()  + " " + info.getTrapOid());
		// 送信Queueの初期化
		SendQueue sendQueue = null;
		
		try {
			sendQueue = new SendQueue(QueueConstant.QUEUE_NAME_LOG);
		} catch (NamingException e1) {
			m_log.error("sendMassage()" +  e1.getMessage());
		} catch (JMSException e1) {
			m_log.error("sendMassage()" +  e1.getMessage());
		}
		
		
//		メッセージ "%parm[#n]%"をバインドされた値で置換
		if(msg != null && !"".equals(msg)){
			String[] values = info.getVarBindValue();
			for (int j = 0; j < values.length; j++) {
				String regex = TrapSnmpManager.REGEX_PREFIX + Integer.toString(j+1) + TrapSnmpManager.REGEX_SUFFIX;
				msg = msg.replaceAll(regex, values[j]);
			}
		}
		else{
			msg = "";
		}
		
		// オリジナルメッセージ
		if(  msgOrg == null || "".equals(msgOrg)){
			// 空の場合、マスタ情報よりオリジナルメッセージを取得
			msgOrg = master.getDescr();
		}
		
		// オリジナルメッセージ "%parm[#n]%"をバインドされた値で置換
		if(msgOrg != null && !"".equals(msgOrg)){
			String[] values = info.getVarBindValue();
			for (int j = 0; j < values.length; j++) {
				String regex = TrapSnmpManager.REGEX_PREFIX + Integer.toString(j+1) + TrapSnmpManager.REGEX_SUFFIX;
				msgOrg = msgOrg.replaceAll(regex, values[j]);
			}
		}
		else{
			msgOrg = "";
		}
		
		// 監視管理への通知メッセージ作成
		LogOutputNotifyInfo notifyInfo = new LogOutputNotifyInfo();
		
		notifyInfo.setMonitorId(info.getMonitorId());
		notifyInfo.setPluginId(TrapSnmpManager.PLUGIN_ID);
		notifyInfo.setPriority(priority);
		
		notifyInfo.setNotifyId(snmpTrapInfo.getNotifyId());
		notifyInfo.setApplication(snmpTrapInfo.getApplication());
		notifyInfo.setFacilityId(info.getFacilityId());
		notifyInfo.setScopeText(facilityPath);
		
		notifyInfo.setGenerationDate(info.getTrapDate());
		
		String messageId = null;
		if(priority == PriorityConstant.TYPE_INFO){
			messageId = TrapSnmpManager.MESSAGE_ID_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			messageId = TrapSnmpManager.MESSAGE_ID_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			messageId = TrapSnmpManager.MESSAGE_ID_CRITICAL;
		}
		else{
			messageId = TrapSnmpManager.MESSAGE_ID_UNKNOWN;
		}
		notifyInfo.setMessageId(messageId);
		notifyInfo.setMessage(msg);
		
		String[] args = {info.getTrapOid(), master.getUei()};
		notifyInfo.setMessageOrg(Messages.getString("message.snmptrap.3", args) + "\n" + msgOrg);
		
		// ジョブ連携のため追加
		// ジョブ連携が有効になっている場合のみその情報を設定する
		if (snmpTrapInfo.getJobRun() == YesNoConstant.TYPE_YES) {
			
			//未登録ノード　スコープの時はジョブ実行しない。
			if(!(info.getFacilityId().equals(FacilityTreeAttributeConstant.UNREGISTEREFD_SCOPE))){
				// 各重要度のジョブ連携設定のリストを取得する
				Iterator itr = snmpTrapInfo.getJudgementInfo().iterator();
				while (itr.hasNext()) {
					MonitorNumericValueInfo mnvi = (MonitorNumericValueInfo)itr.next();
					
					// 通知される重要度のジョブ連携設定を参照する
					if (mnvi.getPriority() == notifyInfo.getPriority()) {
						// ジョブ連携が定義されている場合は、その情報を通知情報に付加する
						if (mnvi.getJobRun() == YesNoConstant.TYPE_YES) {
							LogOutputJobRunInfo jobRunInfo = new LogOutputJobRunInfo();
							jobRunInfo.setJobRun(mnvi.getJobRun());
							jobRunInfo.setJobId(mnvi.getJobId());
							jobRunInfo.setJobInhibitionFlg(mnvi.getJobInhibitionFlg());
							jobRunInfo.setJobFailurePriority(mnvi.getJobFailurePriority());
							notifyInfo.setJobRun(jobRunInfo);
						}
					}
				}
			}
		} // ジョブ連携用追加コードここまで									
		
		try {
			//Queueに送信
			sendQueue.put(notifyInfo);
		}
		catch (Exception e) {
			m_log.error("onMessage() : 監視管理メッセージ送信エラー : " + e.getMessage());
		}
	}
	
}
