/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm.core;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import org.postgresforest.core.ParameterList;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;
import org.postgresforest.util.StreamWrapper;

public class SimpleParameterList
implements ParameterList {
    private static final int IN = 1;
    private static final int OUT = 2;
    private static final int INOUT = 3;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final int[] direction;
    private static final Object NULL_OBJECT = new Object();

    SimpleParameterList(int paramCount) {
        if (paramCount < 0) {
            paramCount = 0;
        }
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.direction = new int[paramCount];
    }

    public void registerOutParameter(int index, int sqlType) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n = index - 1;
        this.direction[n] = this.direction[n] | 2;
    }

    private void bind(int index, Object value, int oid) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramValues[--index] = value;
        int n = index;
        this.direction[n] = this.direction[n] | 1;
        if (oid == 0 && this.paramTypes[index] != 0) {
            return;
        }
        this.paramTypes[index] = oid;
    }

    public int getParameterCount() {
        return this.paramValues.length;
    }

    public int getInParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction[i] == 2) continue;
            ++count;
        }
        return count;
    }

    public int getOutParameterCount() {
        int count = 0;
        int i = this.paramTypes.length;
        while (--i >= 0) {
            if ((this.direction[i] & 2) != 2) continue;
            ++count;
        }
        if (count == 0) {
            count = 1;
        }
        return count;
    }

    public void setIntParameter(int index, int value) throws SQLException {
        this.bind(index, new Integer(value), 23);
    }

    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17);
    }

    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17);
    }

    public void setNull(int index, int oid) throws SQLException {
        this.bind(index, NULL_OBJECT, oid);
    }

    public String toString(int index) {
        if (this.paramValues[--index] == null) {
            return "?";
        }
        if (this.paramValues[index] == NULL_OBJECT) {
            return "NULL";
        }
        return this.paramValues[index].toString();
    }

    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int index) {
        if (this.direction[index - 1] == 2) {
            this.paramTypes[index - 1] = 2278;
            this.paramValues[index - 1] = "null";
        }
        return this.paramTypes[index - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.paramTypes[i] != 0) continue;
            return true;
        }
        return false;
    }

    boolean isNull(int index) {
        return this.paramValues[index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int index) {
        return this.paramValues[index - 1] instanceof StreamWrapper;
    }

    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.direction, 0, newCopy.direction, 0, this.direction.length);
        return newCopy;
    }

    public ParameterList copyTo(ParameterList distParamList) throws SQLException {
        distParamList.clear();
        for (int i = 0; i < this.paramValues.length; ++i) {
            int oidType = this.paramTypes[i];
            int paramIndex = i + 1;
            if (this.paramValues[i] == NULL_OBJECT) {
                distParamList.setNull(paramIndex, this.paramTypes[i]);
                continue;
            }
            if (this.paramValues[i] instanceof StreamWrapper) {
                StreamWrapper streamWrapper = (StreamWrapper)this.paramValues[i];
                byte[] bytes = streamWrapper.getBytes();
                if (bytes == null) {
                    distParamList.setBytea(paramIndex, streamWrapper.getStream(), streamWrapper.getLength());
                    continue;
                }
                distParamList.setBytea(paramIndex, bytes, streamWrapper.getOffset(), streamWrapper.getLength());
                continue;
            }
            if (this.paramValues[i] instanceof Integer && oidType == 23) {
                Integer intValue = (Integer)this.paramValues[i];
                distParamList.setIntParameter(paramIndex, intValue);
                continue;
            }
            if (this.paramValues[i] instanceof String && (oidType == 21 || oidType == 23 || oidType == 701 || oidType == 1700 || oidType == 20)) {
                distParamList.setLiteralParameter(paramIndex, (String)this.paramValues[i], oidType);
                continue;
            }
            distParamList.setStringParameter(paramIndex, (String)this.paramValues[i], oidType);
        }
        return distParamList;
    }

    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill(this.direction, 0);
    }
}

