/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;

public abstract class ElementDrawer {
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final double ONE_POINT_CORNER_OFFSET = 0.5;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    private static final Stroke BORDER_STROKE_THIN = new BasicStroke(0.5f, 0, 0);
    private static final Stroke BORDER_STROKE_1_POINT = new BasicStroke(1.0f, 0, 0);
    private static final Stroke BORDER_STROKE_DOTTED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);

    public abstract void draw(Graphics2D var1, JRPrintElement var2, int var3, int var4) throws JRException;

    protected void drawBox(Graphics2D grx, JRBox box, JRPrintElement element, int offsetX, int offsetY) {
        double cornerOffset;
        Stroke topStroke = null;
        Stroke leftStroke = null;
        Stroke bottomStroke = null;
        Stroke rightStroke = null;
        if (box != null) {
            topStroke = ElementDrawer.getBorderStroke(box.getTopBorder());
            leftStroke = ElementDrawer.getBorderStroke(box.getLeftBorder());
            bottomStroke = ElementDrawer.getBorderStroke(box.getBottomBorder());
            rightStroke = ElementDrawer.getBorderStroke(box.getRightBorder());
        }
        if (topStroke != null) {
            cornerOffset = ElementDrawer.getBorderCornerOffset(box.getTopBorder());
            grx.setStroke(topStroke);
            grx.setColor(box.getTopBorderColor() == null ? element.getForecolor() : box.getTopBorderColor());
            grx.translate(0.0, cornerOffset);
            grx.drawLine(element.getX() + offsetX, element.getY() + offsetY, element.getX() + offsetX + element.getWidth(), element.getY() + offsetY);
            grx.translate(0.0, -cornerOffset);
        }
        if (leftStroke != null) {
            cornerOffset = ElementDrawer.getBorderCornerOffset(box.getLeftBorder());
            grx.setStroke(leftStroke);
            grx.setColor(box.getLeftBorderColor() == null ? element.getForecolor() : box.getLeftBorderColor());
            grx.translate(cornerOffset, 0.0);
            grx.drawLine(element.getX() + offsetX, element.getY() + offsetY, element.getX() + offsetX, element.getY() + offsetY + element.getHeight());
            grx.translate(-cornerOffset, 0.0);
        }
        if (bottomStroke != null) {
            cornerOffset = ElementDrawer.getBorderCornerOffset(box.getBottomBorder());
            grx.setStroke(bottomStroke);
            grx.setColor(box.getBottomBorderColor() == null ? element.getForecolor() : box.getBottomBorderColor());
            grx.translate(0.0, -cornerOffset);
            grx.drawLine(element.getX() + offsetX, element.getY() + offsetY + element.getHeight(), element.getX() + offsetX + element.getWidth(), element.getY() + offsetY + element.getHeight());
            grx.translate(0.0, cornerOffset);
        }
        if (rightStroke != null) {
            cornerOffset = ElementDrawer.getBorderCornerOffset(box.getRightBorder());
            grx.setStroke(rightStroke);
            grx.setColor(box.getRightBorderColor() == null ? element.getForecolor() : box.getRightBorderColor());
            grx.translate(-cornerOffset, 0.0);
            grx.drawLine(element.getX() + offsetX + element.getWidth(), element.getY() + offsetY, element.getX() + offsetX + element.getWidth(), element.getY() + offsetY + element.getHeight());
            grx.translate(cornerOffset, 0.0);
        }
    }

    protected static Stroke getStroke(byte pen) {
        switch (pen) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }

    protected static double getBorderCornerOffset(byte pen) {
        switch (pen) {
            case 5: {
                return 0.25;
            }
            case 1: 
            case 4: {
                return 0.5;
            }
        }
        return 0.0;
    }

    protected static int getRectangleSizeAdjust(byte pen) {
        switch (pen) {
            case 1: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private static Stroke getBorderStroke(byte pen) {
        switch (pen) {
            case 4: {
                return BORDER_STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return BORDER_STROKE_THIN;
            }
        }
        return BORDER_STROKE_1_POINT;
    }
}

