/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.examples;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SendTrapExample {
    public static void main(String[] args) throws Exception {
        SnmpTrapSession trapdSession = new SnmpTrapSession(new SnmpTrapHandler(){

            public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduPacket pdu) {
                System.out.println("ReceivedTrap -> " + SendTrapExample.getPduAsString(pdu));
            }

            public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) {
                System.out.println("ReceivedTrap -> " + SendTrapExample.getPduAsString(pdu));
            }

            public void snmpTrapSessionError(SnmpTrapSession session, int error, Object ref) {
                System.out.println("TrapSessionError -> " + error + " -> " + ref);
            }
        }, 6767);
        SnmpPeer peer = new SnmpPeer(InetAddress.getLocalHost());
        peer.setPort(6767);
        peer.setRetries(1);
        peer.setTimeout(3000);
        SnmpParameters parameters = peer.getParameters();
        parameters.setReadCommunity("public");
        parameters.setVersion(1);
        SnmpPduRequest trapPdu = new SnmpPduRequest(167);
        trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(".1.3.6.1.2.1.1.3.0"), (SnmpSyntax)new SnmpTimeTicks(1010L)));
        trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(".1.3.6.1.6.3.1.1.4.1.0"), (SnmpSyntax)new SnmpObjectId(".1.2")));
        System.out.println("Before send");
        trapdSession.send(peer, (SnmpPduPacket)trapPdu);
        System.out.println("After send (going to sleep for 10 seconds)");
        Thread.sleep(10000L);
        System.out.println("After sleep (going close session)");
        trapdSession.close();
    }

    public static String getPduAsString(SnmpPduTrap trap) {
        StringBuffer stBuff = new StringBuffer();
        stBuff.append(trap.getAgentAddress()).append(", ").append(trap.getEnterprise());
        stBuff.append(", ").append(trap.getGeneric()).append(", ").append(trap.getSpecific());
        stBuff.append(", ").append(trap.getTimeStamp()).append("Data: ");
        SnmpVarBind[] bind = trap.toVarBindArray();
        for (int i = 0; i < bind.length; ++i) {
            stBuff.append(' ').append(bind[i].getName()).append('=').append(bind[i].getValue());
        }
        return stBuff.toString();
    }

    public static String getPduAsString(SnmpPduPacket pdu) {
        StringBuffer stBuff = new StringBuffer();
        stBuff.append(pdu.getCommand()).append(',').append(pdu.getRequestId());
        SnmpVarBind[] bind = pdu.toVarBindArray();
        for (int i = 0; i < bind.length; ++i) {
            stBuff.append(' ').append(bind[i].getName()).append('=').append(bind[i].getValue());
        }
        return stBuff.toString();
    }
}

