/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.examples;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SnmpAgentExample
implements SnmpHandler {
    private static final String PARAM_COMMUNITY = "public";
    private static final int PARAM_RETRIES = 10;
    private static final int PARAM_TIMEOUT = 5000;
    private static final int PARAM_GENERIC_TYPE = 0;
    private static final int PARAM_SPECIFIC_TYPE = 0;
    private String m_trapOid;
    private SnmpSession m_session;

    public SnmpAgentExample(String managerAddress, int managerPort, String trapOid) throws Exception {
        this.m_trapOid = trapOid;
        try {
            SnmpPeer peer = new SnmpPeer(InetAddress.getByName(managerAddress));
            peer.setPort(managerPort);
            peer.setRetries(10);
            peer.setTimeout(5000);
            SnmpParameters parameters = peer.getParameters();
            parameters.setReadCommunity(PARAM_COMMUNITY);
            this.m_session = new SnmpSession(peer);
            this.m_session.setDefaultHandler((SnmpHandler)this);
        }
        catch (Exception e) {
            System.out.println("SNMP agent creation error");
        }
    }

    public void close() {
        this.m_session.close();
    }

    public static void main(String[] args) {
    }

    public void sendV1Trap(String message) throws Exception {
        try {
            SnmpPeer peer = this.m_session.getPeer();
            SnmpParameters parameters = peer.getParameters();
            parameters.setVersion(0);
            SnmpPduTrap trapPdu = new SnmpPduTrap();
            trapPdu.setAgentAddress(new SnmpIPAddress(InetAddress.getLocalHost().getAddress()));
            trapPdu.setGeneric(0);
            trapPdu.setSpecific(0);
            trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(this.m_trapOid), (SnmpSyntax)new SnmpOctetString(message.getBytes())));
            this.m_session.send(trapPdu);
        }
        catch (Exception e) {
            System.out.println("SNMP send error");
        }
    }

    public void sendV2Trap(String message) {
        try {
            SnmpPeer peer = this.m_session.getPeer();
            SnmpParameters parameters = peer.getParameters();
            parameters.setVersion(1);
            SnmpPduRequest trapPdu = new SnmpPduRequest(167);
            trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(this.m_trapOid), (SnmpSyntax)new SnmpOctetString(message.getBytes())));
            this.m_session.send((SnmpPduPacket)trapPdu);
        }
        catch (Exception e) {
            System.out.println("SNMP send error");
        }
    }

    public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        System.out.println("SNMP internal error, code: " + err);
    }

    public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        System.out.println("SNMP timeout");
    }

    public void snmpReceivedPdu(SnmpSession session, int cmd, SnmpPduPacket pdu) {
    }
}

