/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityActions;

class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name, String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        String prop = sm != null ? SystemPropertyAction.PRIVILEGED.getProperty(name, defaultValue) : SystemPropertyAction.NON_PRIVILEGED.getProperty(name, defaultValue);
        return prop;
    }

    static interface SystemPropertyAction {
        public static final SystemPropertyAction PRIVILEGED = new SystemPropertyAction(){

            public String getProperty(String name, String defaultValue) {
                String prop = (String)AccessController.doPrivileged(new PrivilegedAction(this, name, defaultValue){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ String val$defaultValue;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$name = val$name;
                        this.val$defaultValue = val$defaultValue;
                    }

                    public Object run() {
                        String p = System.getProperty(this.val$name, this.val$defaultValue);
                        return p;
                    }
                });
                return prop;
            }
        };
        public static final SystemPropertyAction NON_PRIVILEGED = new SystemPropertyAction(){

            public String getProperty(String name, String defaultValue) {
                String prop = System.getProperty(name, defaultValue);
                return prop;
            }
        };

        public String getProperty(String var1, String var2);
    }
}

