/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;

/**
 * アクセス[ユーザ]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetUserList {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ユーザ一覧情報を取得します。
     * 
     * 戻り値はArrayListのArrayListで内部のArrayListは
	 * 以下の用につめられる。
	 * 
	 * <p>
	 * ArrayList info = new ArrayList();
	 *	    info = new ArrayList();
	 *	    info.add(user.getUid());
	 *	    info.add(user.getCn());
	 *	    info.add(user.getDescription());
	 *	    info.add(user.getCreatorsName());
	 *	    info.add(user.getCreateTimestamp());
	 *	    info.add(user.getModifiersName());
	 *	    info.add(user.getModifyTimestamp());
	 *
	 *	    list.add(info);
	 *</p>
	 * 
     * @return ユーザ一覧情報
     * 
     * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserList()
     */
    public ArrayList getAll() {
    	AccessController access = EjbConnectionManager
        .getConnectionManager().getAccessController();

        ArrayList records = null;
        try {
            records = access.getUserList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * フィルタ条件に一致するユーザ一覧情報を取得します。
     * 
     * @param property フィルタ条件
     * @return ユーザ一覧情報
     * 
     * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#getUserList(com.clustercontrol.bean.Property)
     */
    public ArrayList get(Property property) {
    	AccessController access = EjbConnectionManager
        .getConnectionManager().getAccessController();

        ArrayList records = null;
        try {
        	records = access.getUserList(property);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}