/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.action.ConfirmEvent;
import com.clustercontrol.monitor.composite.EventListComposite;
import com.clustercontrol.monitor.view.EventView;

/**
 * 監視[イベント]ビューの確認アクションによるイベントの確認の更新処理を行うアクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class EventConfirmAction implements IViewActionDelegate {
	
	/** アクションID */
    public static final String ID = "com.clustercontrol.monitor.view.action.EventConfirmAction";

    /** ビュー */
    private IViewPart viewPart;

    
    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * 監視[イベント]ビューの選択されたアイテムを確認に更新し、ビューを更新します。
     * <p>
	 * <ol>
	 * <li>監視[イベント]ビューで、選択されているアイテムを取得します。</li>
	 * <li>取得したイベント情報の確認を確認済みに更新します。 </li>
	 * <li>監視[イベント]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.monitor.view.EventView
     * @see com.clustercontrol.monitor.action.ConfirmEvent#confirm(List)
     * @see com.clustercontrol.monitor.view.EventView#update()
     */
    public void run(IAction action) {
        // 選択アイテムを取得します。
        EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

        EventListComposite composite = (EventListComposite) view
                .getListComposite();
        StructuredSelection selection = (StructuredSelection) composite
                .getTableViewer().getSelection();

        List list = (List) selection.toList();

        // 選択しているイベント情報を「確認済」にして、再描画します。
        if (list != null) {
            if (new ConfirmEvent().confirm(list)) {
                view.update();
            }
        }
    }

    /**
     * 選択を変更した際に呼ばれます。
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}