/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.ejb.EJBException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performance.bean.CollectorItemInfo;


/**
 * 収集項目設定情報のDBアクセスを行うクラス
 * 
 * @version 2.0.0
 * @since 1.0
 */
public class CollectorItemDAO {
	
	//ログ出力
	protected static Log m_log = LogFactory.getLog( CollectorItemDAO.class );
	
	/**
	 * コンストラクター
	 *
	 */
	public CollectorItemDAO(){
		
	}
	
//	/**
//	 * 収集IDと収集項目IDで検索を行う
//	 * @param collectorID　収集ID
//	 * @param collectorItemID 収集項目ID
//	 * @return 収集項目情報
//	 * @throws SQLException
//	 */
//	public CollectorItemInfo selectCollectorItem(String collectorID, int collectorItemID)
//	throws EJBException{
//		m_log.debug("selectCollectorItem() start : " + collectorID + " " + collectorItemID);
//		
//		CollectorItemInfo cinfo = null;
//	
//		Connection conn = null;
//		PreparedStatement stmt = null;
//		// 結果セット
//		ResultSet res = null;
//		
//		try {
//			//コネクションを取得します。
//			conn = ConnectionManager.getConnectionManager().getConnection();
//			
//			//		SQL文の作成
//			String sql = "SELECT * FROM CC_COLLECTOR_ITEM WHERE COLLECTORID=? AND ITEMID = ?";
//			// SQL文発行準備
//			
//			stmt = conn.prepareStatement(sql);
//			
//			stmt.setString(1, collectorID);
//			stmt.setInt(2, collectorItemID);
//			res = stmt.executeQuery();
//			
//			if(res.next()) {
//				
//				cinfo =new  CollectorItemInfo(
//						res.getString("COLLECTORID"),
//						res.getString("COLLECT_METHOD"),
////						res.getString("PLATFORM_ID"),
//						res.getString("ITEM_CODE"),
//						res.getString("DEVICE_NAME")
//				);
//			}
//		} catch (SQLException e) {
//			m_log.error("selectCollectorIte() error :" + collectorID + " " + collectorItemID + " SQLException");
//			throw new EJBException(e.getMessage());
//		}  finally{
//			
//			//コネクション、結果セット、プリペアドステートメントのクロース
//			try {
//				if(res != null){
//					res.close();
//				}
//				if(stmt != null){
//					stmt.close();
//				}
//				if(conn != null){
//					conn.close();
//				}
//			} catch (SQLException e1) {
//				m_log.error("selectCollectorIte() error :" + collectorID + " " + collectorItemID + " SQLException");
//				throw new EJBException(e1.getMessage());
//			}
//		}	
//		m_log.debug("selectCollectorItem() end   : " + collectorID + " " + collectorItemID);
//		return cinfo;
//		
//	}

	/**
	 * 収集項目情報をインサートする
	 * @param cinfo 収集項目情報
	 * @throws SQLException
	 */	
	public void insertCollectorItem(CollectorItemInfo cinfo)
	throws EJBException{
		
		m_log.debug("insertCollectorItem() start :"
				+ cinfo.getCollectorId() + " "
				+ cinfo.getCollectMethod() + " "
				+ cinfo.getItemCode() + " "
				+ cinfo.getDeviceName() + " ");
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//		SQL文の作成
			//SQL文の定義
			String sql = "INSERT INTO CC_COLLECTOR_ITEM " +
			"(collectorid, " +
			"collect_method," +
//			"platform_id" +
			"item_code," +
			"device_name)" +
			"values (?,?,?,?);";
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, cinfo.getCollectorId());
			stmt.setString(2, cinfo.getCollectMethod());
//			stmt.setString(3, cinfo.getPlatformId());
			stmt.setString(3, cinfo.getItemCode());
			stmt.setString(4, cinfo.getDeviceName());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("insertCollectorItem() error :" + cinfo.toString() + " SQLException " + msg);
				
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("insertCollectorItem() error :" + cinfo.toString() + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("insertCollectorItem() error :" + cinfo.toString() + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
			
			m_log.debug("insertCollectorItem() end   :" + cinfo.toString());
		}
	}
	
	/**
	 * 収集IDで検索を行う
	 * 
	 * 収集設定に含まれる項目を一括して取得する
	 * @param collectorID 収集ID
	 * @return　収集項目情報のコレクション
	 * @throws SQLException
	 */
	public List<CollectorItemInfo> selectCollectorItemByCollectorID(String collectorID)
	throws EJBException{
		
		m_log.debug("selectCollectorItemByCollectorID() start :"
				+collectorID);
		
		ArrayList<CollectorItemInfo> ret = new ArrayList<CollectorItemInfo>();
		Connection conn = null;
		PreparedStatement stmt =null;
		// 結果セット
		ResultSet res=null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQL文の作成
			String sql = "SELECT * FROM CC_COLLECTOR_ITEM WHERE COLLECTORID=? " + 
			"ORDER BY ITEM_CODE, DEVICE_NAME";
			// SQL文発行準備
			stmt = conn.prepareStatement(sql);
			
			
			stmt.setString(1, collectorID);
			res = stmt.executeQuery();
			
			while(res.next()) {
				
				CollectorItemInfo  cinfo = new  CollectorItemInfo(
						res.getString("COLLECTORID"),
						res.getString("COLLECT_METHOD"),
//						res.getString("PLATFORM_ID"),
						res.getString("ITEM_CODE"),
						res.getString("DEVICE_NAME")
				);
				
				ret.add(cinfo);
			} 
		} catch (SQLException e) {
			m_log.error("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(res != null){
					res.close();
				}
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("selectCollectorItemByCollectorID() end   :" + collectorID);
		return ret;
	}
	
	/**
	 * 収集IDで削除を行う。
	 * 
	 * ある収集設定に含まれる収集項目情報を一括して削除する
	 * @param collectorID 収集ID
	 * @throws SQLException
	 */
	public void deleteCollectorItemByCollectorID(String collectorID)
	{
		m_log.debug("deleteCollectorItemByCollectorID() start :" + collectorID);
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			String sql = "DELETE FROM CC_COLLECTOR_ITEM WHERE COLLECTORID = ? ";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,collectorID );
			stmt.executeUpdate();
			
		} catch (SQLException e) {
			m_log.error("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
			throw new EJBException(e.getMessage());
		}  finally{
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteCollectorItemByCollectorID() error :" + collectorID + " SQLException ");
				throw new EJBException(e1.getMessage());
			}
		}	
		
		
		m_log.debug("deleteCollectorItemByCollectorID() end   :" + collectorID);
	}
}
	
