/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.ejb.session;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;


import com.clustercontrol.performance.bean.QuartzConstant;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;



/**
 *　無期限収集のチェックを行うQuartzスケジュールを登録するクラス
 * 通常はマネージャDBのイニシャライズ時にのみ使用します。
 * 
 * @ejb.bean name="CollectorRunController"
 *           display-name="Name for CollectorRunController"
 *           description="Description for CollectorRunController"
 *           jndi-name="CollectorRunController"
 *           type="Stateless"
 *           view-type="remote"
 *
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 */
public class CollectorRunControllerBean implements SessionBean {
	
	private static final long serialVersionUID = 1L;
	protected static Log m_log = LogFactory.getLog( CollectorRunControllerBean.class );
	
	
	/**
	 * Quartzからのコールバックメソッド
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * 	@ejb.permission
	 *     unchecked="true"
	 *     method-intf="Remote"
	 *     
	 * @throws FinderException
	 * @throws NamingException
	 * @since 2.0.0
	 */
	public void managePresavePeriod() throws FinderException, NamingException {
		m_log.debug("managePresavePeriod() :  start");
		
		//get Hame Interface 
		CollectorHome home = JNDIConnectionManager.getCollectorHome();
		Collection myBeans;
		
		try {
			myBeans = home.findByPresave();	
			Iterator it = myBeans.iterator();
			
			
			//while Loop
			while(it.hasNext()){
				
				Collector bean = (Collector)it.next();
				//無期限収集それぞれにたいして、処理をおこないます。			
				

				if(bean.getPresavePeriod() >= 0){
					//保存期間と現在日時から、保存期間の日時を計算
					Calendar cal = Calendar.getInstance();				
					cal.add(Calendar.DAY_OF_MONTH, -bean.getPresavePeriod());
					cal.set(Calendar.MILLISECOND,0);
					cal.set(Calendar.SECOND,0);
					
					Date startDate = (Date)cal.getTime();
					
					m_log.debug("managePresavePeriod() :  presaveDate " + " " + startDate.toString());
					if(startDate.after(bean.getStartDate())){
						
						//収集開始時刻を書き変える(GUI対策)?					
						bean.setStartDate(startDate);
						
						//収集開始時刻以前のデータを削除する。
						//収集回数を再定義する。
						bean.managePresave(startDate);
						
					}//end if
				}	// end while Loop			
			}
		} catch (RemoteException e) {
			
			e.printStackTrace();
		} catch (FinderException e) {
			
			e.printStackTrace();
		}
		
		m_log.debug("managePresavePeriod() :  end");
	}
	
	/**
	 * Quartzへスケジュールを登録します
	 * 
	 * @param cronString スケジュール実行ルールのcron表現
	 *  
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     unchecked="true"
	 *     method-intf="Remote"
	 * 
	 * @throws NamingException
	 * @throws ParseException
	 * @throws SchedulerException
	 * 
	 * @since 2.0.0
	 */
	public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
		//QuartzのSchedulerを削除します。
		QuartzManager manager = QuartzUtil.getQuartzManager();
		try {
			//Quartzマネージャを
			manager.deleteSchedule(QuartzConstant.JNDI_NAME_PERF_MNG, 
					QuartzConstant.GROUP_COLLECT);
		} catch (SchedulerException e) {
			m_log.debug("addQuartz() : deleteJob error = " + e.getMessage());
		} catch (RemoteException e) {
		}
		
		//JobDetail
		JobDetail job = new JobDetail(
				QuartzConstant.JNDI_NAME_PERF_MNG, 
				QuartzConstant.GROUP_COLLECT,
				EJBInvokerJob.class);
		
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			job.getJobDataMap().put(
					EJBInvokerJob.PROVIDER_URL, 
			"jnp://localhost:1100");
		}
		
		
		job.setDurability(true);
		
		//JobDetail
		job.getJobDataMap().put(
				EJBInvokerJob.EJB_JNDI_NAME_KEY, 
				QuartzConstant.JNDI_NAME_PERF_MNG);
		//
		job.getJobDataMap().put(
				EJBInvokerJob.EJB_METHOD_KEY, 
				QuartzConstant.METHOD_NAME_PERF_MNG);
		
		//CronTrigger?
		CronTrigger cronTrigger = new CronTrigger(QuartzConstant.JNDI_NAME_PERF_MNG, QuartzConstant.GROUP_COLLECT);
		
        //起動失敗した場合は、次の起動予定時刻をセットするように設定
        cronTrigger.setMisfireInstruction(CronTrigger.MISFIRE_INSTRUCTION_DO_NOTHING);
		
		// cronString = "0 */1 * * * ? *";
		cronTrigger.setCronExpression(cronString);
		
		//Scheduler       
		try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
		}
	}
	
	/**
	 * Quartzからスケジュールを削除します
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     unchecked="true"
	 *     method-intf="Remote"
	 * 
	 * @throws NamingException
	 * @throws ParseException
	 * @throws SchedulerException
	 * 
	 * @since 2.0.0
	 */
	public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
		//Quartz
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
		try {
			manager.deleteSchedule(QuartzConstant.JNDI_NAME_PERF_MNG, 
					QuartzConstant.GROUP_COLLECT);
		} catch (SchedulerException e) {
			m_log.debug("deleteQuartz() : deleteJob error = " + e.getMessage());
		} catch (RemoteException e) {
		}
	}
	
	/**
	 * Beanからセッション・コンテキストを取得します。
	 * （実装されていません）
	 */
	public void setSessionContext(SessionContext ctx)
	throws EJBException,
	RemoteException {
	}
	
	/**
	 * SessionBean削除時にコンテナから呼ばれます。
	 */
	public void ejbRemove() throws EJBException, RemoteException {
	}
	
	/**
	 * SessionBeanインスタンスが「活性化」状態になる前にコンテナから呼ばれます。
	 */
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	/**
	 * SessionBeanインスタンスが「非活性化」状態になる前にコンテナから呼ばれます。
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
	}
}
