/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.port.bean.MonitorPortInfo;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoUtil;
import com.clustercontrol.port.ejb.session.MonitorPortRunManagementHome;

/**
 * port監視情報登録クラス
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class AddMonitorPort extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorPort.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		
		// port監視情報を設定
		MonitorPortInfo port = (MonitorPortInfo)m_monitorInfo.getCheckInfo();
		
		MonitorPortInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorTypeId(),
				m_monitorInfo.getMonitorId(),
				port.getPortNo(),
				port.getRunCount(),
				port.getRunInterval(),
				port.getTimeout(),
				port.getServiceId());
		return true;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorPortRunManagementHome.JNDI_NAME;
	}
}
