// 
//    jSNMP - SNMPv1 & v2 Compliant Libraries for Java
//    Copyright (C) 2000  PlatformWorks, Inc.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//   
// For more information contact: 
//  Brian Weaver      <weave@opennms.org>
//  http://www.opennms.org/
//
//  joeSNMP Licensing <joesnmp-license@lists.sourceforge.net>
//  http://sourceforge.net/projects/joesnmp/
//

package org.opennms.examples;

import java.net.InetAddress;

import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSMI;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SendTrapExample
{
    public static void main(String[] args) throws Exception
    {
        SnmpTrapSession trapdSession = new SnmpTrapSession(new SnmpTrapHandler()
        {
            public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port,
                    SnmpOctetString community, SnmpPduPacket pdu)
            {
                System.out.println("ReceivedTrap -> " + SendTrapExample.getPduAsString(pdu));
            }

            public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port,
                    SnmpOctetString community, SnmpPduTrap pdu)
            {
                System.out.println("ReceivedTrap -> " + SendTrapExample.getPduAsString(pdu));
            }

            public void snmpTrapSessionError(SnmpTrapSession session, int error, Object ref)
            {
                System.out.println("TrapSessionError -> " + error + " -> " + ref);
            }
        }, 6767);
        
        SnmpPeer peer = new SnmpPeer(InetAddress.getLocalHost());
        peer.setPort(6767);
        peer.setRetries(1);
        peer.setTimeout(3000);
        
        SnmpParameters parameters = peer.getParameters();
        parameters.setReadCommunity("public");
        parameters.setVersion(SnmpSMI.SNMPV2);
        
        // Create trap
        SnmpPduRequest trapPdu = new SnmpPduRequest(SnmpPduPacket.V2TRAP);
        trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(".1.3.6.1.2.1.1.3.0"), new SnmpTimeTicks(1010))); // sysUpTime
        trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(".1.3.6.1.6.3.1.1.4.1.0"), new SnmpObjectId(".1.2"))); // trapOid
        
        System.out.println("Before send");
        trapdSession.send(peer, trapPdu);
        System.out.println("After send (going to sleep for 10 seconds)");
        Thread.sleep(10000);
        System.out.println("After sleep (going close session)");
        trapdSession.close();
    }
    
    public static String getPduAsString(SnmpPduTrap trap)
    {
        StringBuffer stBuff = new StringBuffer();
        stBuff.append(trap.getAgentAddress()).append(", ").append(trap.getEnterprise());
        stBuff.append(", ").append(trap.getGeneric()).append(", ").append(trap.getSpecific());
        stBuff.append(", ").append(trap.getTimeStamp()).append("Data: ");
        SnmpVarBind bind[] = trap.toVarBindArray();
        for (int i = 0; i < bind.length; i++)
            stBuff.append(' ').append(bind[i].getName()).append('=').append(bind[i].getValue());

        return stBuff.toString();
    }

    public static String getPduAsString(SnmpPduPacket pdu)
    {
        StringBuffer stBuff = new StringBuffer();
        stBuff.append(pdu.getCommand()).append(',').append(pdu.getRequestId());
        SnmpVarBind bind[] = pdu.toVarBindArray();
        for (int i = 0; i < bind.length; i++)
            stBuff.append(' ').append(bind[i].getName()).append('=').append(bind[i].getValue());

        return stBuff.toString();
    }
    
}
