/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.BoxDrawer;
import net.sf.jasperreports.engine.export.draw.EllipseDrawer;
import net.sf.jasperreports.engine.export.draw.ImageDrawer;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import net.sf.jasperreports.engine.export.draw.RectangleDrawer;
import net.sf.jasperreports.engine.export.draw.TextDrawer;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    private static final int ELEMENT_RECTANGLE_PADDING = 3;
    private static final float DEFAULT_ZOOM = 1.0f;
    public static final String MINIMIZE_PRINTER_JOB_SIZE = "net.sf.jasperreports.export.graphics2d.min.job.size";
    protected Graphics2D grx = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected float zoom = 1.0f;
    protected TextRenderer textRenderer = null;
    protected LineDrawer lineDrawer = null;
    protected RectangleDrawer rectangleDrawer = null;
    protected EllipseDrawer ellipseDrawer = null;
    protected ImageDrawer imageDrawer = null;
    protected TextDrawer textDrawer = null;
    protected BoxDrawer boxDrawer = null;

    public JRGraphics2DExporter() throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        try {
            this.setExportContext();
            this.setInput();
            this.setPageRange();
            this.setTextRenderer();
            this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
            if (this.grx == null) {
                throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
            }
            this.setDrawers();
            Float zoomRatio = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO);
            if (zoomRatio != null) {
                this.zoom = zoomRatio.floatValue();
                if (this.zoom <= 0.0f) {
                    throw new JRException("Invalid zoom ratio : " + this.zoom);
                }
            } else {
                this.zoom = 1.0f;
            }
            this.exportReportToGraphics2D();
        }
        finally {
            this.resetExportContext();
        }
    }

    protected void setTextRenderer() {
        boolean isMinimizePrinterJobSize = true;
        Boolean isMinimizePrinterJobSizeParam = (Boolean)this.parameters.get(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE);
        isMinimizePrinterJobSize = isMinimizePrinterJobSizeParam == null ? JRProperties.getBooleanProperty(MINIMIZE_PRINTER_JOB_SIZE) : isMinimizePrinterJobSizeParam;
        this.textRenderer = new TextRenderer(isMinimizePrinterJobSize);
    }

    protected void setDrawers() {
        this.lineDrawer = new LineDrawer();
        this.rectangleDrawer = new RectangleDrawer();
        this.ellipseDrawer = new EllipseDrawer();
        this.imageDrawer = new ImageDrawer();
        this.textDrawer = new TextDrawer(this.textRenderer, this.styledTextParser);
        this.boxDrawer = new BoxDrawer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReportToGraphics2D() throws JRException {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform atrans = new AffineTransform();
        atrans.translate(this.globalOffsetX, this.globalOffsetY);
        atrans.scale(this.zoom, this.zoom);
        this.grx.transform(atrans);
        List pages = this.jasperPrint.getPages();
        if (pages != null) {
            Shape oldClipShape = this.grx.getClip();
            this.grx.clip(new Rectangle(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
            try {
                JRPrintPage page = (JRPrintPage)pages.get(this.startPageIndex);
                this.exportPage(page);
            }
            finally {
                this.grx.setClip(oldClipShape);
            }
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        List elements = page.getElements();
        this.exportElements(elements);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws JRException {
        if (elements != null && elements.size() > 0) {
            Shape clipArea = this.grx.getClip();
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (!clipArea.intersects(element.getX() + this.getOffsetX() - 3, element.getY() + this.getOffsetY() - 3, element.getWidth() + 6, element.getHeight() + 6)) continue;
                if (element instanceof JRPrintLine) {
                    this.lineDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.rectangleDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.ellipseDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.imageDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.textDrawer.draw(this.grx, element, this.getOffsetX(), this.getOffsetY());
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws JRException {
        if (frame.getMode() == 1) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            this.grx.setColor(frame.getBackcolor());
            this.grx.fillRect(x, y, frame.getWidth(), frame.getHeight());
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.boxDrawer.draw(this.grx, frame, this.getOffsetX(), this.getOffsetY());
    }
}

