/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.ConditionalImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class InstrumentData {
    private String className;
    private String sourceFileName;
    private Set sourceLineNumbers = new HashSet();
    private Map conditionalsByMethod = new HashMap();
    private Map sourceLineNumbersByMethod = new HashMap();
    private Set methodNamesAndSignatures = new TreeSet();

    public InstrumentData(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void addSourceNumber(String methodName, String signature, int sourceNumber) {
        Set sourceSet = this.getSourceNumberByMethodSet(methodName, signature);
        Integer number = new Integer(sourceNumber);
        sourceSet.add(number);
        this.sourceLineNumbers.add(number);
    }

    public Set getSourceLineNumbers() {
        return this.sourceLineNumbers;
    }

    public Map getMethodLineNumbers() {
        return this.sourceLineNumbersByMethod;
    }

    public Map getMethodConditionals() {
        return this.conditionalsByMethod;
    }

    public Set getMethodNamesAndSignatures() {
        return this.methodNamesAndSignatures;
    }

    public void addMethodNamesAndSignatures(String methodName, String signature) {
        String key = String.valueOf(methodName) + signature;
        this.methodNamesAndSignatures.add(key);
        this.conditionalsByMethod.put(key, new HashSet());
    }

    public void addConditional(String methodName, String signature, int brunchLine, int targetLine) {
        String key = String.valueOf(methodName) + signature;
        HashSet<ConditionalImpl> conditionalsSet = (HashSet<ConditionalImpl>)this.conditionalsByMethod.get(key);
        if (conditionalsSet == null) {
            conditionalsSet = new HashSet<ConditionalImpl>();
            this.conditionalsByMethod.put(key, conditionalsSet);
        }
        conditionalsSet.add(new ConditionalImpl(brunchLine, targetLine));
    }

    private Set getSourceNumberByMethodSet(String methodName, String signature) {
        String key = String.valueOf(methodName) + signature;
        if (!this.sourceLineNumbersByMethod.containsKey(key)) {
            this.sourceLineNumbersByMethod.put(key, new TreeSet());
        }
        return (Set)this.sourceLineNumbersByMethod.get(key);
    }
}

