/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock;

import jp.co.dgic.testing.common.AbstractBcelImplementer;
import jp.co.dgic.testing.common.util.DJUnitUtil;
import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import jp.co.dgic.testing.common.virtualmock.VirtualMockUtil;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class BcelAdviceImplementer
extends AbstractBcelImplementer {
    private static final String NULL_RETURN_VALUE_CLASS_NAME = "jp.co.dgic.testing.common.virtualmock.NullReturnValue";

    public BcelAdviceImplementer() {
        super("VirtualMockObjects");
    }

    protected byte[] modify(JavaClass jc) throws Exception {
        return this.modifyClass(jc);
    }

    public byte[] modifyClass(JavaClass jc) throws ClassNotFoundException {
        String className = jc.getClassName();
        if (!VirtualMockUtil.isUseVirtualMock()) {
            return null;
        }
        if (!VirtualMockUtil.isInclude(className)) {
            return null;
        }
        if (jc.isInterface() || jc.isAnnotation() || jc.isEnum()) {
            return null;
        }
        ClassGen cg = new ClassGen(jc);
        InstructionFactory ifactory = new InstructionFactory(cg, cg.getConstantPool());
        Method[] methods = cg.getMethods();
        InternalMockObjectManager.printConsole("<<<" + methods.length + " methods found. >>>");
        int index = 0;
        while (index < methods.length) {
            InternalMockObjectManager.printConsole("#################################################################");
            InternalMockObjectManager.printConsole("#################################################################");
            InternalMockObjectManager.printConsole("### " + (methods[index].isAbstract() ? "abstract " : "") + className + "#" + methods[index].getName());
            InternalMockObjectManager.printConsole("#################################################################");
            InternalMockObjectManager.printConsole("#################################################################");
            if (!(methods[index].isAbstract() || methods[index].isNative() || methods[index].isVolatile())) {
                MethodGen mg = new MethodGen(methods[index], className, cg.getConstantPool());
                InstructionList il = mg.getInstructionList();
                this.modifyMethodCall(cg, mg, ifactory);
                if (this.isConstructor(mg)) {
                    InstructionHandle superOrThisHandle = this.findSuperOrThis(cg, mg, il, mg.getConstantPool());
                    if (superOrThisHandle != null) {
                        il.append(superOrThisHandle, this.createInsertClause(ifactory, mg));
                    } else {
                        il.insert(this.createInsertClause(ifactory, mg));
                    }
                } else {
                    il.insert(this.createInsertClause(ifactory, mg));
                }
                mg.setMaxStack();
                mg.setMaxLocals();
                cg.replaceMethod(methods[index], mg.getMethod());
                il.dispose();
            }
            ++index;
        }
        return cg.getJavaClass().getBytes();
    }

    private void modifyMethodCall(ClassGen cg, MethodGen mg, InstructionFactory ifactory) throws ClassNotFoundException {
        ConstantPoolGen cpg = mg.getConstantPool();
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] handles = il.getInstructionHandles();
        int i = 0;
        while (i < handles.length) {
            InvokeInstruction ii = null;
            if (handles[i].getInstruction() instanceof InvokeInstruction) {
                ii = (InvokeInstruction)handles[i].getInstruction();
                String className = ii.getClassName(cpg);
                String methodName = ii.getMethodName(cpg);
                Type returnType = Type.getReturnType((String)ii.getSignature(cpg));
                String signature = ii.getSignature(cpg);
                JavaClass jc = this.findOwnerClass(mg, className, methodName, signature);
                if (jc != null) {
                    className = jc.getClassName();
                }
                boolean isStatic = false;
                boolean isInterface = false;
                if (!className.startsWith("jp.co.dgic.testing.common.virtualmock.")) {
                    if (ii.getOpcode() == 184) {
                        isStatic = true;
                    }
                    if (ii.getOpcode() == 185) {
                        isInterface = true;
                    }
                    if (this.isConstructor(methodName)) {
                        boolean isAfterDup = this.isAfterDup(i, handles);
                        int indexOfNewOpcode = this.getIndexOfNewOpcode(i, handles);
                        if (indexOfNewOpcode >= 0) {
                            Instruction newInstruction = handles[indexOfNewOpcode].getInstruction();
                            this.createConstructorCall(cg, mg, ifactory, il, ii, handles[i], className, methodName, isAfterDup);
                        }
                    } else {
                        this.createMethodCall(mg, ifactory, il, ii, handles[i], className, methodName, returnType, isStatic, isInterface);
                    }
                }
            }
            ++i;
        }
    }

    private boolean canReplace(String className, boolean isInterface) {
        if (DJUnitUtil.isDJUnitSystemClass(className)) {
            return false;
        }
        if (DJUnitUtil.isDefaultExcludedPath(className)) {
            return false;
        }
        if (!isInterface && this.isOwnSource(className)) {
            return false;
        }
        return !this.isIgnore(className);
    }

    private boolean canNewExprReplace(String className) {
        if (DJUnitUtil.isDJUnitSystemClass(className)) {
            return false;
        }
        if (DJUnitUtil.isDefaultExcludedPath(className)) {
            return false;
        }
        if (this.isIgnore(className)) {
            return this.isOwnSource(className);
        }
        return true;
    }

    private boolean isIgnore(String className) {
        if (!this.isIgnoreLibrary()) {
            return false;
        }
        return !VirtualMockUtil.isNotIgnore(className);
    }

    private boolean isIgnoreLibrary() {
        String ignoreLibrary = System.getProperty("jp.co.dgic.eclipse.virtualmock.ignore.library");
        if (ignoreLibrary == null || "".equals(ignoreLibrary)) {
            return false;
        }
        if ("false".equalsIgnoreCase(ignoreLibrary)) {
            return false;
        }
        return "true".equalsIgnoreCase(ignoreLibrary);
    }

    private void createConstructorCall(ClassGen cg, MethodGen mg, InstructionFactory ifactory, InstructionList il, InvokeInstruction ii, InstructionHandle ih, String className, String methodName, boolean isAfterDup) throws ClassNotFoundException {
        if (className.equals(cg.getSuperclassName())) {
            return;
        }
        if (className.equals(cg.getClassName())) {
            return;
        }
        ConstantPoolGen cpg = ifactory.getConstantPool();
        String signature = ii.getSignature(cpg);
        boolean isStatic = false;
        ObjectType returnType = new ObjectType(className);
        InternalMockObjectManager.printConsole("[INVOKE CONSTRUCTOR] : " + className + "#" + methodName + " " + signature + "(args.length = " + ii.getArgumentTypes(cpg).length + ") " + "(" + ii + ") " + "[" + ii.getLoadClassType(cpg) + "] ");
        if (!this.canNewExprReplace(className)) {
            return;
        }
        InstructionList beforeCall = new InstructionList();
        beforeCall.append(this.createCopyStackArgsToLocalVariables(mg, false, ii, ifactory));
        int varStartIndex = mg.getMaxLocals() + 1;
        beforeCall.append(this.createCreateArgsArray(mg, ii.getArgumentTypes(cpg), false, varStartIndex, ifactory));
        beforeCall.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        beforeCall.append((CompoundInstruction)new PUSH(cpg, this.isOwnSource(className)));
        beforeCall.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "indicateCalledAndGetReturnValueForNewExpr", (Type)Type.OBJECT, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1), Type.BOOLEAN}, (short)184));
        beforeCall.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        BranchInstruction ifnull = InstructionFactory.createBranchInstruction((short)198, null);
        beforeCall.append(ifnull);
        if (this.isOwnSource(className)) {
            beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            int startIndex = mg.getMaxLocals() + 1;
            beforeCall.append(this.createCreateArgsArray(mg, ii.getArgumentTypes(cpg), false, startIndex, ifactory));
            beforeCall.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
            beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            beforeCall.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "indicateCalled", (Type)Type.VOID, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1)}, (short)184));
            beforeCall.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        }
        beforeCall.append(this.createThrowExceptions(mg, ifactory, className, methodName, signature));
        beforeCall.append(this.createInvokeThrowException(mg, className, methodName, ifactory));
        beforeCall.append(this.createCheckReturnValueOfMethodCall(mg, className, methodName, (Type)returnType, ifactory));
        if (isAfterDup) {
            beforeCall.append((Instruction)new POP());
            beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            beforeCall.append((Instruction)new INSTANCEOF(cpg.addClass(new ObjectType(NULL_RETURN_VALUE_CLASS_NAME))));
            BranchInstruction branch = InstructionFactory.createBranchInstruction((short)154, null);
            beforeCall.append(branch);
            beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            beforeCall.append((Instruction)ifactory.createCheckCast((ReferenceType)new ObjectType(className)));
            BranchInstruction gotoreturn = InstructionFactory.createBranchInstruction((short)167, null);
            beforeCall.append(gotoreturn);
            InstructionHandle ifne = beforeCall.append(InstructionConstants.ACONST_NULL);
            branch.setTarget(ifne);
            InstructionHandle end = beforeCall.append((Instruction)new NOP());
            gotoreturn.setTarget(end);
        }
        BranchInstruction gotoEnd = InstructionFactory.createBranchInstruction((short)167, null);
        beforeCall.append(gotoEnd);
        InstructionHandle notmock = beforeCall.append(this.createPutArgsIntoStackFromLocalValriables(mg, false, ii, ifactory));
        ifnull.setTarget(notmock);
        il.insert((Instruction)ii, beforeCall);
        InstructionHandle end = il.append((Instruction)ii, (Instruction)new NOP());
        gotoEnd.setTarget(end);
    }

    private void createMethodCall(MethodGen mg, InstructionFactory ifactory, InstructionList il, InvokeInstruction ii, InstructionHandle ih, String className, String methodName, Type returnType, boolean isStatic, boolean isInterface) throws ClassNotFoundException {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        String signature = ii.getSignature(cpg);
        InternalMockObjectManager.printConsole("[INVOKE METHOD] : " + className + "#" + methodName + " " + signature + "(args.length = " + ii.getArgumentTypes(cpg).length + ") " + "(" + ii + ") " + "[" + ii.getLoadClassType(cpg) + "] " + (isStatic ? " [static]" : ""));
        if (!this.canReplace(className, isInterface)) {
            return;
        }
        InstructionList beforeCall = new InstructionList();
        beforeCall.append(this.createCopyStackArgsToLocalVariables(mg, isStatic, ii, ifactory));
        int varStartIndex = mg.getMaxLocals() + 1;
        beforeCall.append(this.createCreateArgsArray(mg, ii.getArgumentTypes(cpg), isStatic, varStartIndex, ifactory));
        beforeCall.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        beforeCall.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "indicateCalledAndGetReturnValue", (Type)Type.OBJECT, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1)}, (short)184));
        beforeCall.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        BranchInstruction ifnull = InstructionFactory.createBranchInstruction((short)198, null);
        beforeCall.append(ifnull);
        beforeCall.append(this.createThrowExceptions(mg, ifactory, className, methodName, signature));
        beforeCall.append(this.createInvokeThrowException(mg, className, methodName, ifactory));
        beforeCall.append(this.createCheckReturnValueOfMethodCall(mg, className, methodName, returnType, ifactory));
        if (ii.produceStack(cpg) > 0) {
            beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            beforeCall.append((Instruction)new INSTANCEOF(cpg.addClass(new ObjectType(NULL_RETURN_VALUE_CLASS_NAME))));
            BranchInstruction branch = InstructionFactory.createBranchInstruction((short)154, null);
            beforeCall.append(branch);
            beforeCall.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            if (this.isPrimitive(returnType)) {
                String wrapperType = this.toWrapperType(returnType);
                beforeCall.append((Instruction)ifactory.createCheckCast((ReferenceType)new ObjectType(wrapperType)));
                beforeCall.append((Instruction)ifactory.createInvoke(wrapperType, returnType + "Value", returnType, Type.NO_ARGS, (short)182));
            } else if (this.isArrayType(returnType)) {
                beforeCall.append((Instruction)ifactory.createCheckCast((ReferenceType)((ArrayType)returnType)));
            } else {
                beforeCall.append((Instruction)ifactory.createCheckCast((ReferenceType)new ObjectType(returnType.toString())));
            }
            BranchInstruction gotoreturn = InstructionFactory.createBranchInstruction((short)167, null);
            beforeCall.append(gotoreturn);
            InstructionHandle ifne = beforeCall.append(this.toZeroInstruction(returnType, cpg));
            branch.setTarget(ifne);
            InstructionHandle end = beforeCall.append((Instruction)new NOP());
            gotoreturn.setTarget(end);
        }
        BranchInstruction gotoEnd = InstructionFactory.createBranchInstruction((short)167, null);
        beforeCall.append(gotoEnd);
        InstructionHandle notmock = beforeCall.append(this.createPutArgsIntoStackFromLocalValriables(mg, isStatic, ii, ifactory));
        ifnull.setTarget(notmock);
        il.insert((Instruction)ii, beforeCall);
        InstructionHandle end = il.append((Instruction)ii, (Instruction)new NOP());
        gotoEnd.setTarget(end);
    }

    private InstructionList createInsertClause(InstructionFactory ifactory, MethodGen mg) {
        InstructionList beforeList = new InstructionList();
        beforeList.append(this.createInvokeIndicateCalledAndGetReturnValue(mg, ifactory));
        beforeList.append(this.createReturnValueProcess(mg, ifactory));
        return beforeList;
    }

    private InstructionList createPrintArgument(int index, Type type, InstructionFactory ifactory) {
        InstructionList il = new InstructionList();
        il.append((Instruction)ifactory.createFieldAccess("java.lang.System", "out", (Type)new ObjectType("java.io.PrintStream"), (short)178));
        il.append((Instruction)InstructionFactory.createLoad((Type)type, (int)index));
        Type argType = type;
        if (!this.isPrimitive(type)) {
            argType = Type.OBJECT;
        }
        il.append((Instruction)ifactory.createInvoke("java.io.PrintStream", "println", (Type)Type.VOID, new Type[]{argType}, (short)182));
        return il;
    }

    private Instruction toZeroInstruction(Type returnType, ConstantPoolGen cpg) {
        if (Type.BOOLEAN.equals((Object)returnType)) {
            return new PUSH(cpg, false).getInstruction();
        }
        if (Type.BYTE.equals((Object)returnType)) {
            return new PUSH(cpg, 0).getInstruction();
        }
        if (Type.CHAR.equals((Object)returnType)) {
            return new PUSH(cpg, 0).getInstruction();
        }
        if (Type.DOUBLE.equals((Object)returnType)) {
            return new PUSH(cpg, 0.0).getInstruction();
        }
        if (Type.FLOAT.equals((Object)returnType)) {
            return new PUSH(cpg, 0.0f).getInstruction();
        }
        if (Type.INT.equals((Object)returnType)) {
            return new PUSH(cpg, 0).getInstruction();
        }
        if (Type.LONG.equals((Object)returnType)) {
            return new PUSH(cpg, 0L).getInstruction();
        }
        if (Type.SHORT.equals((Object)returnType)) {
            return new PUSH(cpg, 0).getInstruction();
        }
        return InstructionConstants.ACONST_NULL;
    }

    private boolean isArrayType(String typeName) {
        if (typeName == null) {
            return false;
        }
        return typeName.endsWith("[]");
    }

    private boolean isArrayType(Type type) {
        return type instanceof ArrayType;
    }

    private InstructionList createInvokeIndicateCalledAndGetReturnValue(MethodGen mg, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        il.append(this.createCreateArgsArray(mg, mg.getArgumentTypes(), mg.isStatic(), 0, ifactory));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(mg.getClassName(), mg.getName())));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "indicateCalledAndGetReturnValue", (Type)Type.OBJECT, new Type[]{Type.STRING, new ArrayType((Type)Type.OBJECT, 1)}, (short)184));
        il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        return il;
    }

    private InstructionList createReturnValueProcess(MethodGen mg, InstructionFactory ifactory) {
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        BranchInstruction ifnull = InstructionFactory.createBranchInstruction((short)198, null);
        il.append(ifnull);
        il.append(this.createThrowExceptions(mg, ifactory, mg.getExceptions()));
        il.append(this.createInvokeThrowException(mg, ifactory));
        Type returnType = Type.getReturnType((String)mg.getSignature());
        il.append(this.createCheckReturnValue(mg, mg.getClassName(), mg.getName(), returnType, ifactory));
        il.append(this.createReturnValue(mg, ifactory));
        InstructionHandle nop = il.append((Instruction)new NOP());
        ifnull.setTarget(nop);
        return il;
    }

    private InstructionList createReturnValue(MethodGen mg, InstructionFactory ifactory) {
        InstructionList il = new InstructionList();
        Type returnType = Type.getReturnType((String)mg.getSignature());
        if (Type.VOID.equals((Object)returnType)) {
            il.append((Instruction)InstructionFactory.createReturn((Type)mg.getReturnType()));
            return il;
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((Instruction)new INSTANCEOF(mg.getConstantPool().addClass(new ObjectType(NULL_RETURN_VALUE_CLASS_NAME))));
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)154, null);
        il.append(branch);
        if (!this.isPrimitive(returnType)) {
            il.append((Instruction)InstructionFactory.createLoad((Type)mg.getReturnType(), (int)mg.getMaxLocals()));
            if (this.isArrayType(returnType)) {
                il.append((Instruction)ifactory.createCheckCast((ReferenceType)((ArrayType)returnType)));
            } else {
                il.append((Instruction)ifactory.createCheckCast((ReferenceType)new ObjectType(returnType.toString())));
            }
        } else {
            String wrapperType = this.toWrapperType(returnType);
            String valueMethod = returnType + "Value";
            il.append((Instruction)InstructionFactory.createLoad((Type)new ObjectType(wrapperType), (int)mg.getMaxLocals()));
            il.append((Instruction)ifactory.createCheckCast((ReferenceType)new ObjectType(wrapperType)));
            il.append((Instruction)ifactory.createInvoke(wrapperType, valueMethod, returnType, Type.NO_ARGS, (short)182));
        }
        BranchInstruction gotoreturn = InstructionFactory.createBranchInstruction((short)167, null);
        il.append(gotoreturn);
        InstructionHandle ifne = il.append(this.toZeroInstruction(returnType, mg.getConstantPool()));
        branch.setTarget(ifne);
        InstructionHandle end = il.append((Instruction)InstructionFactory.createReturn((Type)mg.getReturnType()));
        gotoreturn.setTarget(end);
        return il;
    }

    private InstructionList createInvokeThrowException(MethodGen mg, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(mg.getClassName(), mg.getName())));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "throwException", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)184));
        return il;
    }

    private InstructionList createInvokeThrowException(MethodGen mg, String className, String methodName, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "throwException", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)184));
        return il;
    }

    private InstructionList createCheckReturnValue(MethodGen mg, String className, String methodName, Type returnType, InstructionFactory ifactory) {
        if (this.isConstructor(mg)) {
            return this.createInvokeCheckReturnTypeIsIgnoreReturnValue(mg, className, methodName, ifactory);
        }
        if (Type.VOID.equals((Object)returnType)) {
            return this.createInvokeCheckReturnTypeIsIgnoreOrNullReturnValue(mg, className, methodName, ifactory);
        }
        return this.createCheckReturnValueType(mg, className, methodName, returnType, ifactory);
    }

    private InstructionList createCheckReturnValueOfMethodCall(MethodGen mg, String className, String methodName, Type returnType, InstructionFactory ifactory) {
        if (this.isConstructor(methodName)) {
            return this.createInvokeCheckReturnTypeForNewExpr(mg, className, methodName, ifactory);
        }
        if (Type.VOID.equals((Object)returnType)) {
            return this.createInvokeCheckReturnTypeIsIgnoreOrNullReturnValue(mg, className, methodName, ifactory);
        }
        return this.createCheckReturnValueType(mg, className, methodName, returnType, ifactory);
    }

    private InstructionList createInvokeCheckReturnTypeIsIgnoreOrNullReturnValue(MethodGen mg, String className, String methodName, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "checkReturnTypeIsIgnoreOrNullReturnValue", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)184));
        return il;
    }

    private InstructionList createInvokeCheckReturnTypeIsIgnoreReturnValue(MethodGen mg, String className, String methodName, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "checkReturnTypeIsIgnoreReturnValue", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)184));
        return il;
    }

    private InstructionList createInvokeCheckReturnTypeForNewExpr(MethodGen mg, String className, String methodName, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((Instruction)new INSTANCEOF(cpg.addClass(new ObjectType(className))));
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)154, null);
        il.append(branch);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "checkReturnTypeForNewExpr", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)184));
        branch.setTarget(il.append((Instruction)new NOP()));
        return il;
    }

    private InstructionList createCheckReturnValueType(MethodGen mg, String className, String methodName, Type returnType, InstructionFactory ifactory) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        ObjectType returnObjectType = null;
        returnObjectType = this.isPrimitive(returnType) ? new ObjectType(this.toWrapperType(returnType)) : new ObjectType(returnType.toString());
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        if (this.isArrayType(returnType)) {
            il.append((Instruction)new INSTANCEOF(cpg.addArrayClass((ArrayType)returnType)));
        } else {
            il.append((Instruction)new INSTANCEOF(cpg.addClass(returnObjectType)));
        }
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)154, null);
        il.append(branch);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
        il.append((CompoundInstruction)new PUSH(cpg, this.makeKey(className, methodName)));
        il.append((Instruction)ifactory.createInvoke("jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager", "checkReturnTypeIsNullReturnValue", (Type)Type.VOID, new Type[]{Type.OBJECT, Type.STRING}, (short)184));
        InstructionHandle nop = il.append((Instruction)new NOP());
        branch.setTarget(nop);
        return il;
    }

    private InstructionHandle getExceptionHandler(MethodGen mg, InstructionHandle ih, String exceptionType) {
        CodeExceptionGen[] handlers = mg.getExceptionHandlers();
        if (handlers == null) {
            return null;
        }
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i].getCatchType() != null && this.containsTarget(handlers[i], ih) && handlers[i].getCatchType().toString().equals(exceptionType)) {
                return handlers[i].getHandlerPC();
            }
            ++i;
        }
        return null;
    }

    private boolean containsTarget(CodeExceptionGen ce, InstructionHandle ih) {
        if (ce.getStartPC().getPosition() > ih.getPosition()) {
            return false;
        }
        return ce.getEndPC().getPosition() >= ih.getPosition();
    }

    private InstructionList createThrowExceptions(MethodGen mg, InstructionFactory ifactory, String className, String methodName, String signature) throws ClassNotFoundException {
        return this.createThrowExceptions(mg, ifactory, this.getExceptions(className, methodName, signature));
    }

    private String[] getExceptions(String className, String methodName, String signature) throws ClassNotFoundException {
        MethodGen mg = this.getMethod(className, methodName, signature);
        if (mg == null) {
            return null;
        }
        return mg.getExceptions();
    }

    private MethodGen getMethod(String className, String methodName, String signature) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass((String)className);
        MethodGen mg = this.getMethod(jc, methodName, signature);
        if (mg != null) {
            return mg;
        }
        JavaClass[] interfaces = jc.getInterfaces();
        if (interfaces == null) {
            return null;
        }
        int i = 0;
        while (i < interfaces.length) {
            mg = this.getMethod(interfaces[i], methodName, signature);
            if (mg != null) {
                return mg;
            }
            ++i;
        }
        return null;
    }

    private MethodGen getMethod(JavaClass jc, String methodName, String signature) throws ClassNotFoundException {
        if (jc == null) {
            return null;
        }
        ClassGen cg = new ClassGen(jc);
        Method method = cg.containsMethod(methodName, signature);
        if (method != null) {
            return new MethodGen(method, jc.getClassName(), cg.getConstantPool());
        }
        if ("java.lang.Object".equals(jc.getClassName())) {
            return null;
        }
        return this.getMethod(jc.getSuperClass(), methodName, signature);
    }

    private InstructionList createThrowExceptions(MethodGen mg, InstructionFactory ifactory, String[] exceptions) {
        ConstantPoolGen cpg = ifactory.getConstantPool();
        InstructionList il = new InstructionList();
        if (exceptions == null || exceptions.length == 0) {
            il.append((Instruction)new NOP());
            return il;
        }
        int i = 0;
        while (i < exceptions.length) {
            InternalMockObjectManager.printConsole("exceptions[" + i + "] : " + exceptions[i]);
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            il.append((Instruction)new INSTANCEOF(cpg.addClass(new ObjectType(exceptions[i]))));
            BranchInstruction ifeq = InstructionFactory.createBranchInstruction((short)153, null);
            il.append(ifeq);
            il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)mg.getMaxLocals()));
            il.append((Instruction)ifactory.createCheckCast((ReferenceType)new ObjectType(exceptions[i])));
            il.append(InstructionConstants.ATHROW);
            InstructionHandle nop = il.append((Instruction)new NOP());
            ifeq.setTarget(nop);
            ++i;
        }
        return il;
    }

    private String makeKey(String className, String methodName) {
        return String.valueOf(className) + "." + methodName;
    }
}

