/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.examples;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class TrapdExample
implements SnmpTrapHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            SnmpTrapSession testTrapSession = new SnmpTrapSession((SnmpTrapHandler)new TrapdExample());
            System.out.println("SNMP Trap Receiver Started");
            SnmpTrapSession snmpTrapSession = testTrapSession;
            synchronized (snmpTrapSession) {
                testTrapSession.wait();
            }
            System.out.println("SNMP Trap Receiver Exiting");
            testTrapSession.close();
        }
        catch (Exception e) {
            System.out.println("Exception in main(): " + e);
            e.printStackTrace();
        }
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        System.out.println("V2 Trap from agent " + agent.toString() + " on port " + port);
        System.out.println("V2 Trap PDU command......... " + pdu.getCommand());
        System.out.println("V2 Trap PDU ID.............. " + pdu.getRequestId());
        System.out.println("V2 Trap PDU Length.......... " + pdu.getLength());
        if (pdu instanceof SnmpPduRequest) {
            System.out.println("V2 Trap PDU Error Status.... " + ((SnmpPduRequest)pdu).getErrorStatus());
            System.out.println("V2 Trap PDU Error Index..... " + ((SnmpPduRequest)pdu).getErrorIndex());
        }
        int k = pdu.getLength();
        for (int i = 0; i < k; ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            System.out.print("Varbind[" + i + "] := " + vb.getName().toString());
            System.out.println(" --> " + vb.getValue().toString());
        }
        System.out.println("");
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) {
        System.out.println("V1 Trap from agent " + agent.toString() + " on port " + port);
        System.out.println("Ip Address................. " + pdu.getAgentAddress());
        System.out.println("Enterprise Id.............. " + pdu.getEnterprise());
        System.out.println("Generic ................... " + pdu.getGeneric());
        System.out.println("Specific .................. " + pdu.getSpecific());
        System.out.println("TimeStamp ................. " + pdu.getTimeStamp());
        System.out.println("Length..................... " + pdu.getLength());
        int k = pdu.getLength();
        for (int i = 0; i < k; ++i) {
            SnmpVarBind vb = pdu.getVarBindAt(i);
            System.out.print("Varbind[" + i + "] := " + vb.getName().toString());
            System.out.println(" --> " + vb.getValue().toString());
        }
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTrapSessionError(SnmpTrapSession session, int error, Object ref) {
        System.out.println("An error occured in the trap session");
        System.out.println("Session error code = " + error);
        if (ref != null) {
            System.out.println("Session error reference: " + ref.toString());
        }
        if (error == -1) {
            SnmpTrapSession snmpTrapSession = session;
            synchronized (snmpTrapSession) {
                session.notify();
            }
        }
    }
}

