/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.CommonTableViewerSorter;

/**
 * カレンダ用テーブルビューワークラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarTableViewer extends CommonTableViewer {
	
    /**
     * コンストラクタ
     * 
     * @param parent
     */
    public CalendarTableViewer(Composite parent) {
        super(parent);
    }

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     */
    public CalendarTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    /**
     * コンストラクタ
     * 
     * @param table
     */
    public CalendarTableViewer(Table table) {
        super(table);
    }

    /**
     * テーブルカラムの作成処理<BR>
     * 
     * @param tableColumnList
     */
    public void createTableColumn(ArrayList tableColumnList,
            int sortColumnIndex, int sortOrder) {
        this.m_tableColumnList = tableColumnList;

        for (int i = 0; i < this.m_tableColumnList.size(); i++) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo) this.m_tableColumnList
                    .get(i);
            TableColumn column = new TableColumn(getTable(), tableColumnInfo
                    .getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());

            //初期表示時のソート
            if (i == sortColumnIndex) {
                int order = sortOrder;
                tableColumnInfo.setOrder(order);
                setSorter(new CommonTableViewerSorter(i, order));
            }
        }
    }
}