/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.util.Messages;

/**
 * ジョブ操作用プロパティを作成するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobOperationProperty {
	/** セッションID */
    public static final String SESSION = "session";
    /** ジョブID */
    public static final String JOB = "job";
    /** ファシリティID */
    public static final String FACILITY = "facility";
    /** 制御 */
    public static final String CONTROL = "control";
    /** 終了値 */
    public static final String END_VALUE = "endValue";
    
	/**
	 * ジョブ開始操作用プロパティを返します。
	 * <p>
	 * <ol>
	 *  <li>項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義する各項目は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>セッションID（子。テキスト）</li>
	 *   <li>ジョブID（子。テキスト）</li>
	 *   <li>ファシリティID（子。テキスト）</li>
	 *   <li>制御（子。コンボボックス）</li>
	 *   <ul>
	 *    <li>終了値（孫。テキスト）</li>
	 *   </ul>
	 *  </ul>
	 * </ul>
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @param locale ロケール情報
	 * @return ジョブ開始操作用プロパティ
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public Property getStartProperty(String sessionId, String jobId, String facilityId, Locale locale) {
	    //セッションID
		Property session =
			new Property(SESSION, Messages.getString("session.id", locale), PropertyConstant.EDITOR_TEXT);
	    //ジョブID
		Property job =
			new Property(JOB, Messages.getString("job.id", locale), PropertyConstant.EDITOR_TEXT);
	    //ファシリティID
		Property facility =
			new Property(FACILITY, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT);
		//制御
		Property control =
			new Property(CONTROL, Messages.getString("control", locale), PropertyConstant.EDITOR_SELECT);
        
	    int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//セッションIDとジョブIDから、セッションジョブを取得
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
	                
	                //実行状態を取得
	                status = childSessionJob.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //セッションIDとジョブIDから、セッションジョブを取得
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobId, facilityId));
	                
	                //実行状態を取得
	                status = sessionNode.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //実行状態を取得
                status = sessionJob.getStatus().intValue();
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {

        }
        
        ArrayList<String> values = new ArrayList<String>();
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_AT_ONCE, jobType, status)){
		    values.add(OperationConstant.STRING_START_AT_ONCE);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_SUSPEND, jobType, status)){
		    values.add(OperationConstant.STRING_START_SUSPEND);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_WAIT, jobType, status)){
		    values.add(OperationConstant.STRING_START_WAIT);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_START_SKIP, jobType, status)){
		    values.add(OperationConstant.STRING_START_SKIP);
		}
		
		//値を初期化
		Object controlValues[][] = {values.toArray(), values.toArray()};
		
		control.setSelectValues(controlValues);
		if(values.size() >= 1){
		    control.setValue(values.get(0));
		}
		else{
		    control.setValue("");
		}
		
		session.setValue(sessionId);
		job.setValue(jobId);
		if(facilityId != null && facilityId.length() > 0){
		    facility.setValue(facilityId);
		}
		else{
		    facility.setValue("");
		}
		
		//変更の可/不可を設定
		session.setModify(PropertyConstant.MODIFY_NG);
		job.setModify(PropertyConstant.MODIFY_NG);
		facility.setModify(PropertyConstant.MODIFY_NG);
		control.setModify(PropertyConstant.MODIFY_OK);

		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(session);
		property.addChildren(job);
		if(facilityId != null && facilityId.length() > 0){
		    property.addChildren(facility);
		}
		property.addChildren(control);
		
		return property;
	}
	
	/**
	 * ジョブ停止操作用プロパティを返します。
	 * <p>
	 * <ol>
	 *  <li>項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義する各項目は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>セッションID（子。テキスト）</li>
	 *   <li>ジョブID（子。テキスト）</li>
	 *   <li>ファシリティID（子。テキスト）</li>
	 *   <li>制御（子。コンボボックス）</li>
	 *   <ul>
	 *    <li>終了値（孫。テキスト）</li>
	 *   </ul>
	 *  </ul>
	 * </ul>
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @param locale ロケール情報
	 * @return ジョブ停止操作用プロパティ
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	@SuppressWarnings("unchecked")
	public Property getStopProperty(String sessionId, String jobId, String facilityId, Locale locale) {
	    //セッションID
		Property session =
			new Property(SESSION, Messages.getString("session.id", locale), PropertyConstant.EDITOR_TEXT);
	    //ジョブID
		Property job =
			new Property(JOB, Messages.getString("job.id", locale), PropertyConstant.EDITOR_TEXT);
	    //ファシリティID
		Property facility =
			new Property(FACILITY, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT);
		//制御
		Property control =
			new Property(CONTROL, Messages.getString("control", locale), PropertyConstant.EDITOR_SELECT);
	    //終了値
		Property endValue =
			new Property(END_VALUE, Messages.getString("end.value", locale), PropertyConstant.EDITOR_NUM, 
					DataRangeConstant.SMALLINT_HIGH, DataRangeConstant.SMALLINT_LOW);
		
	    ArrayList endList = new ArrayList();
	    endList.add(endValue);
	    
	    HashMap skipEndMap = new HashMap();
	    skipEndMap.put("value", OperationConstant.STRING_STOP_SKIP);
	    skipEndMap.put("property", endList);
	    
	    HashMap mainteEndMap = new HashMap();
	    mainteEndMap.put("value", OperationConstant.STRING_STOP_MAINTENANCE);
	    mainteEndMap.put("property", endList);
	    
	    int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//セッションIDとジョブIDから、セッションジョブを取得
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
	                
	                //実行状態を取得
	                status = childSessionJob.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //セッションIDとジョブIDから、セッションジョブを取得
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobId, facilityId));
	                
	                //実行状態を取得
	                status = sessionNode.getStatus().intValue();
	                
	                //ジョブタイプを取得
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //セッションIDとジョブIDから、セッションジョブを取得
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //実行状態を取得
                status = sessionJob.getStatus().intValue();
                
                //ジョブタイプを取得
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {

        }
        
        ArrayList<String> values1 = new ArrayList<String>();
        ArrayList values2 = new ArrayList();
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_AT_ONCE, jobType, status)){
		    values1.add(OperationConstant.STRING_STOP_AT_ONCE);
		    values2.add(OperationConstant.STRING_STOP_AT_ONCE);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_SUSPEND, jobType, status)){
		    values1.add(OperationConstant.STRING_STOP_SUSPEND);
		    values2.add(OperationConstant.STRING_STOP_SUSPEND);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_WAIT, jobType, status)){
		    values1.add(OperationConstant.STRING_STOP_WAIT);
		    values2.add(OperationConstant.STRING_STOP_WAIT);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_SKIP, jobType, status)){
		    values1.add(OperationConstant.STRING_STOP_SKIP);
		    values2.add(skipEndMap);
		}
		if(JobOperationJudgment.judgment(OperationConstant.TYPE_STOP_MAINTENANCE, jobType, status)){
		    values1.add(OperationConstant.STRING_STOP_MAINTENANCE);
		    values2.add(mainteEndMap);
		}
		
		//値を初期化
		Object controlValues[][] = {values1.toArray(), values2.toArray()};
		
		control.setSelectValues(controlValues);
		if(values1.size() >= 1){
		    control.setValue(values1.get(0));
		}
		else{
		    control.setValue("");
		}
		
		endValue.setValue("");
		
		session.setValue(sessionId);
		job.setValue(jobId);
		if(facilityId != null && facilityId.length() > 0){
		    facility.setValue(facilityId);
		}
		else{
		    facility.setValue("");
		}
		
		//変更の可/不可を設定
		session.setModify(PropertyConstant.MODIFY_NG);
		job.setModify(PropertyConstant.MODIFY_NG);
		facility.setModify(PropertyConstant.MODIFY_NG);
		control.setModify(PropertyConstant.MODIFY_OK);
		endValue.setModify(PropertyConstant.MODIFY_OK);

		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(session);
		property.addChildren(job);
		if(facilityId != null && facilityId.length() > 0){
		    property.addChildren(facility);
		}
		property.addChildren(control);
		
		if(OperationConstant.STRING_STOP_SKIP.compareTo((String)control.getValue()) == 0 || 
				OperationConstant.STRING_STOP_MAINTENANCE.compareTo((String)control.getValue()) == 0){
		    control.addChildren(endValue);
		}
		
		return property;
	}
}
