/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.bean;

import java.io.Serializable;

/**
 * 収集項目のPKクラス
 * 
 * @version 1.0
 * @since 1.0
 *
 */
public class CollectorItemPK implements Serializable
{
	private static final long serialVersionUID = -8419150148785571055L;

	private String collectorId;   //収集ID
	private String collectMethod; //収集方法
//	private String platformId;    //プラットフォーム
	private String itemCode;      //収集項目コード
	private String deviceName;    //デバイス名称

   public CollectorItemPK(){}

   /**
    * コンストラクタ
    * 収集項目コードとデバイス番号を設定した状態で、CollectorItemPKクラスのインスタンスを生成します。
    * 
    * @param collectorId 収集ID
    * @param collectMethod 収集方法
    * @param platformId プラットフォーム
    * @param itemCode 収集項目コード
    * @param deviceIndex デバイス名称
    */
   public CollectorItemPK(String collectorId, String collectMethod,/* String platformId,*/ String itemCode,  String deviceName){
	   this.collectorId = collectorId;
	   this.collectMethod = collectMethod;
//	   this.platformId = platformId;
	   this.itemCode = itemCode;
	   this.deviceName = deviceName;
   }

   /**
    * 収集IDを取得します。
    * @return 収集ID
    */
   public String getCollectorId(){
      return collectorId;
   }  
   /**
    * 収集方法を取得します。
    * @return 収集方法
    */
   public String getCollectMethod(){
      return collectMethod;
   }  
//   /**
//    * プラットフォームを取得します。
//    * @return プラットフォーム
//    */
//   public String getPlatformId(){
//      return platformId;
//   }
   /**
    * 収集項目コードを取得します。
    * @return 収集項目コード
    */
   public String getItemCode(){
      return itemCode;
   }
   /**
    * デバイス名称を取得します。
    * @return デバイス名称
    */
   public String getDeviceName(){
      return deviceName;
   }
  
   /**
    * このオブジェクトと他のオブジェクトが等しいかどうかを示します。
    */
   public boolean equals(Object o) {  	
	   if(this == o){
		   return true;
	   }
	   
	   if(o instanceof CollectorItemPK){
		   CollectorItemPK other = (CollectorItemPK)o;
		   boolean equals = false;
		   
		   if(this.itemCode == null || other.itemCode == null){
			   equals = false;
		   } else if(this.collectorId.equals(other.collectorId) && 
				   this.collectMethod.equals(other.collectMethod) && 
//				   this.platformId.equals(other.platformId) && 
				   this.itemCode.equals(other.itemCode) && 
				   this.deviceName.equals(other.deviceName)){
			   equals = true;
		   }
		   
		   return equals;
	   } else {
		   return false;
	   }
   }
   
   /**
    * オブジェクトのハッシュコード値を返します。
    */
   public int hashCode() {
//	   int result = 17;
//	   
//	   result = 37*result + ((this.itemCode != null) ? this.itemCode.hashCode() : 0);
//	   result = 37*result + deviceIndex;
//	   
//	   return result;
	   int _hashCode = 0;
	   if (this.collectorId != null) _hashCode += this.collectorId.hashCode();
       if (this.collectMethod != null) _hashCode += this.collectMethod.hashCode();
//     if (this.platformId != null) _hashCode += this.platformId.hashCode();
       if (this.itemCode != null) _hashCode += this.itemCode.hashCode();
       if (this.deviceName != null) _hashCode += this.deviceName.hashCode();

    return _hashCode;
    }
}
