/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoPK;

/**
 * 値の型定義情報を管理するEntity Bean <BR>
 * @ejb.bean name="CollectorDeviceInfo"
 *           jndi-name="CollectorDeviceInfo"
 *           type="CMP"
 *           schema="CollectorDeviceInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="collectorId","facilityId","deviceName"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_device_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorDeviceInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorDeviceInfo as a where a.collectorId = ?1"  
 *    signature="java.util.Collection findByCollectorId(java.lang.String collectorId)"  
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoPK"
 *   
 */
public abstract class CollectorDeviceInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorDeviceInfoPK ejbCreate(
			String collectorId,
			String facilityId,
			String deviceName,
			Long index,
			String deviceId,
			String deviceType
			) throws javax.ejb.CreateException {
		
		this.setCollectorId(collectorId);
		this.setFacilityId(facilityId);
		this.setDeviceName(deviceName);
		this.setIndex(index);
		this.setDeviceId(deviceId);
		this.setDeviceType(deviceType);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param collectorId 収集ID
	 * @param facilityId ファシリティID
	 * @param deviceName デバイス名称
	 * @param index デバイス番号
	 * @param deviceId デバイスID
	 * @param deviceType デバイス種別
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String collectorId,
			String facilityId,
			String deviceName,
			Integer index,
			String deviceId,
			String deviceType
			) throws javax.ejb.CreateException {
	}
	
	/**
	 * 収集IDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="collectorid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the collectorId.
	 */
	public abstract String getCollectorId();

	/**
	 * 収集IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param collectorId The collectorId to set.
	 */
	public abstract void setCollectorId(String collectorId);

	/**
	 * ファシリティIDを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facilityid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public abstract String getFacilityId();

	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public abstract void setFacilityId(String facilityId);

	/**
	 * デバイス名称を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the deviceName.
	 */
	public abstract String getDeviceName();

	/**
	 * デバイス名称を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param deviceName The deviceName to set.
	 */
	public abstract void setDeviceName(String deviceName);

	/**
	 * デバイス番号を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="index"
	 *     jdbc-type="BIGINT"
	 *     sql-type="bigint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the index.
	 */
	public abstract Long getIndex();

	/**
	 * デバイス番号を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param index The index to set.
	 */
	public abstract void setIndex(Long index);

	/**
	 * デバイス番号を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the deviceId.
	 */
	public abstract String getDeviceId();

	/**
	 * デバイス番号を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param deviceId The deviceId to set.
	 */
	public abstract void setDeviceId(String deviceId);

	/**
	 * デバイス番号を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="device_type"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the deviceType.
	 */
	public abstract String getDeviceType();

	/**
	 * デバイス番号を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param deviceType The deviceType to set.
	 */
	public abstract void setDeviceType(String deviceType);

}
