#!/bin/bash

#
# Hinemos addon for RRDTool
#   性能値CSVファイル出力スクリプト
# 
# @version 1.0.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_rrdtool.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

JBOSS_DEPLOY=${JBOSS_HOME}/server/default/deploy
JBOSS_LIB=${JBOSS_HOME}/server/default/lib
HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}:${DIR}/lib:${DIR}/lib/hinemos_rrdtool.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/AccessControlEJB.jar:${JBOSS_DEPLOY}/PerformanceEJB.jar

CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/hinemos-commons.jar:${HINEMOS_LIB}/clustercontrol.jar:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/log4j-1.2.14.jar:${HINEMOS_LIB}/commons-logging-1.1.jar

${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} com.clustercontrol.performance.rrdtool.PerformanceCSVExport $* 2>/dev/null
RET=$?

echo ${RET}
exit ${RET}