/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.rrdtool.csv;

/**
 * Hinemos Addon for RRDTool<br>
 * 出力するCSVファイルのカラムを定義するクラス<br>
 * 
 * @since 3.0.0
 */
public class CSVColumn {

	private String columnName = null;
	private String itemCode = null;
	private String deviceName = null;

	/**
	 * 収集項目IDとデバイス名を元に、CSVColumnオブジェクトを生成します。
	 * 
	 * @param itemCode
	 *            収集項目ID
	 * @param deviceName
	 *            デバイス名
	 */
	public CSVColumn(String columnName, String itemCode, String deviceName) {
		this.columnName = columnName;
		this.itemCode = itemCode;
		this.deviceName = deviceName;
	}

	public String getColumnName() {
		return columnName;
	}

	public String getItemCode() {
		return itemCode;
	}

	public String getDeviceName() {
		return deviceName;
	}

	/**
	 * CSVColumnオブジェクトが同一の収集定義かどうか、比較します。<br>
	 * 
	 * @param compare
	 *            比較対象のCSVColumnオブジェクト
	 * @return 同一の収集定義の場合true、その他の場合false
	 */
	public boolean equalsCollection(CSVColumn compare) {
		return equalsCollection(compare.getItemCode(), compare.getDeviceName());
	}

	/**
	 * CSVColumnオブジェクトが同一の収集定義かどうか、比較します。<br>
	 * 
	 * @param itemCode
	 *            収集ID
	 * @param deviceName
	 *            デバイス名
	 * @return 同一の収集定義の場合true、その他の場合false
	 */
	public boolean equalsCollection(String itemCode, String deviceName) {
		boolean ret = false;

		if (this.itemCode != null && this.deviceName != null) {
			if (this.itemCode.equals(itemCode) && this.deviceName.equals(deviceName)) {
				ret = true;
			}
		}

		return ret;
	}
}
