/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.rrdtool.util;

import java.util.ResourceBundle;

/**
 * Hinemos Addon for RRDTool<br>
 * 設定ファイルに定義した情報を管理するクラス<br>
 * 
 * @since 3.0.0
 */
public class Config {

	// 環境情報
	private static final ResourceBundle CONFIG = ResourceBundle.getBundle("config");

	// メッセージ情報
	private static final ResourceBundle MSG = ResourceBundle.getBundle("message");

	/**
	 * 特定の環境情報を取得する。
	 * 
	 * @param key
	 *            パラメータ名
	 * @return 設定ファイルに記述された値
	 */
	public static String getConfig(String key) {
		return CONFIG.getString(key);
	}

	/**
	 * 特定のメッセージ情報を取得する。
	 * 
	 * @param key
	 *            パラメータ名
	 * @return 設定ファイルに記述された値
	 */
	public static String getMsg(String key) {
		return MSG.getString(key);
	}
}
