package com.clustercontrol.performance.rrdtool;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

import com.clustercontrol.performance.rrdtool.PerformanceCSVExport;
import com.clustercontrol.performance.rrdtool.csv.CSVColumn;

import jp.co.dgic.testing.framework.DJUnitTestCase;
import junit.framework.TestCase;

public class PerformanceCSVExportUT001 extends DJUnitTestCase {

	private static String file01N = "resource/ut_check/001_01N.def";
	private static String file02N = "resource/ut_check/001_02N.def";
	private static String file03N = "resource/ut_check/001_03N.def";
	private static String file04N = "resource/ut_check/001_04N.def";
	private static String file05N = "resource/ut_check/001_05N.def";
	private static String file06N = "resource/ut_check/001_06N.def";

	private static String file01E = "resource/ut_check/notfound";
	private static String file02E = "resource/ut_check/001_02E.def";
	private static String file03E = "resource/ut_check/001_03E.def";
	private static String file04E = "resource/ut_check/001_04E.def";
	private static String file05E = "resource/ut_check/001_05E.def";
	private static String file06E = "resource/ut_check/001_06E.def";
	private static String file07E = "resource/ut_check/001_07E.def";
	private static String file08E = "resource/ut_check/001_08E.def";
	private static String file09E = "resource/ut_check/001_09E.def";

	public PerformanceCSVExportUT001() {
		super();
	}
	
	public void setUp() throws Exception {
		super.setUp();
	}

	public void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が0の場合
	 */
	public void testN01() {
		ArrayList<CSVColumn> csvColsExpect = new ArrayList<CSVColumn>();
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file01N);

		compareCsvCols(csvColsExpect, csvCols);
	}

	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, デバイス名なしの場合（カラム名に半角スペースなし）
	 */
	public void testN02() {
		ArrayList<CSVColumn> csvColsExpect = new ArrayList<CSVColumn>();
		csvColsExpect.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file02N);

		compareCsvCols(csvColsExpect, csvCols);
	}

	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, デバイス名なしの場合（カラム名の途中に半角スペースあり）
	 */
	public void testN03() {
		ArrayList<CSVColumn> csvColsExpect = new ArrayList<CSVColumn>();
		csvColsExpect.add(new CSVColumn("CPU ALL", "CPU0100_CPU_UTIL", ""));

		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file03N);

		compareCsvCols(csvColsExpect, csvCols);
	}

	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, デバイス名ありの場合（カラム名に半角スペースなし）
	 */
	public void testN04() {
		ArrayList<CSVColumn> csvColsExpect = new ArrayList<CSVColumn>();
		csvColsExpect.add(new CSVColumn("NW_PCK", "NET0100_PACKET", "eth0"));
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file04N);

		compareCsvCols(csvColsExpect, csvCols);
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, デバイス名ありの場合（カラム名に半角スペースあり）
	 */
	public void testN05() {
		ArrayList<CSVColumn> csvColsExpect = new ArrayList<CSVColumn>();
		csvColsExpect.add(new CSVColumn("NW PCK", "NET0100_PACKET", "eth0"));
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file05N);

		compareCsvCols(csvColsExpect, csvCols);
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が3の場合
	 */
	public void testN06() {
		ArrayList<CSVColumn> csvColsExpect = new ArrayList<CSVColumn>();
		csvColsExpect.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvColsExpect.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		csvColsExpect.add(new CSVColumn("NW_PCK eth0", "NET0100_PACKET", "eth0"));
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file06N);

		compareCsvCols(csvColsExpect, csvCols);
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 指定されたファイルが存在しない場合
	 */
	public void testE01() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file01E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(12, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, 書式不正（4カラム）の場合
	 */
	public void testE02() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file02E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/** 
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, 書式不正（1カラム）の場合
	 */
	public void testE03() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file03E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/** 
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, 書式不正（カラム名に半角カンマが含まれる）の場合
	 */
	public void testE04() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file04E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/** 
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, 書式不正（カラム名にダブルクォートが含まれる）の場合
	 */
	public void testE05() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file05E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/** 
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が1, ファイルのcloseに失敗した場合
	 */
	public void testE06() {
		addReturnValue("java.lang.System", "exit");
		addReturnValue("java.io.BufferedReader", "close", new IOException());
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file06E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(12, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が3, 第1項目の書式不正（1カラム）の場合
	 */
	public void testE07() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file07E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が3, 第2項目の書式不正（1カラム）の場合
	 */
	public void testE08() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file08E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 出力項目数が3, 第3項目の書式不正（1カラム）の場合
	 */
	public void testE09() {
		addReturnValue("java.lang.System", "exit");
		ArrayList<CSVColumn> csvCols = PerformanceCSVExport.readColumnDefFile(file09E);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(13, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}

	/**
	 * PerformanceCSVExport.readColumnDefFileメソッド単体試験<br>
	 * 汎用メソッド（出力項目定義オブジェクトの比較）
	 */
	private void compareCsvCols(ArrayList<CSVColumn> csvColsExpect, ArrayList<CSVColumn> csvCols) {
		assertEquals("カラム数の確認", csvColsExpect.size(), csvCols.size());

		for (int i = 0; i < csvColsExpect.size(); i++) {
			assertEquals("カラム名の確認", csvColsExpect.get(i).getColumnName(), csvCols.get(i).getColumnName());
			assertEquals("収集項目IDの確認", csvColsExpect.get(i).getItemCode(), csvCols.get(i).getItemCode());
			if (csvColsExpect.get(i).getDeviceName() == null) {
				assertNull("デバイス名の確認", csvCols.get(i).getDeviceName());
			} else {
				assertEquals("デバイス名の確認", csvColsExpect.get(i).getDeviceName(), csvCols.get(i).getDeviceName());
			}
		}
	}
}
