package com.clustercontrol.performance.rrdtool;

import java.io.File;
import java.util.ArrayList;

import com.clustercontrol.performance.rrdtool.PerformanceCSVExport;
import com.clustercontrol.performance.rrdtool.csv.CSVColumn;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;

import junit.framework.TestCase;

public class PerformanceCSVExportUT003 extends TestCase {

	public PerformanceCSVExportUT003() {
		super();
	}

	public void setUp() throws Exception {
		super.setUp();
	}

	public void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が1つ（デバイス名なし）, 該当する出力項目1つ（デバイス名なし）の場合
	 */
	public void testN01() {
		CollectorProperty property = new CollectorProperty();

		assertTrue("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty1(), csvCols1()));
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が1つ（デバイス名なし）, 該当しない出力項目1つ（デバイス名なし）の場合
	 */
	public void testN02() {
		CollectorProperty property = new CollectorProperty();

		assertFalse("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty1(), csvCols2()));
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が1つ（デバイス名なし）, 該当しない出力項目1つ（デバイス名あり）の場合
	 */
	public void testN03() {
		CollectorProperty property = new CollectorProperty();

		assertFalse("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty1(), csvCols3()));
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が1つ（デバイス名あり）, 該当する出力項目1つ（デバイス名あり）の場合
	 */
	public void testN04() {
		CollectorProperty property = new CollectorProperty();

		assertTrue("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty2(), csvCols4()));
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が1つ（デバイス名あり）, 該当しない出力項目1つ（デバイス名なし）の場合
	 */
	public void testN05() {
		CollectorProperty property = new CollectorProperty();

		assertFalse("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty2(), csvCols2()));
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が1つ（デバイス名あり）, 該当しない出力項目1つ（デバイス名あり）の場合
	 */
	public void testN06() {
		CollectorProperty property = new CollectorProperty();

		assertFalse("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty2(), csvCols3()));
	}

	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が7つ、該当する出力項目5つ（重複なし）の場合
	 */
	public void testN07() {
		CollectorProperty property = new CollectorProperty();

		assertTrue("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty3(), csvCols5()));
	}
	
	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が7つ、該当しない出力項目が含まれる場合
	 */
	public void testN08() {
		CollectorProperty property = new CollectorProperty();

		assertFalse("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty3(), csvCols6()));
	}
	
	/**
	 * PerformanceCSVExport.checkCollectorDefinitionメソッド単体試験<br>
	 * 収集項目定義が7つ、該当する出力項目（重複あり）の場合
	 */
	public void testN09() {
		CollectorProperty property = new CollectorProperty();

		assertTrue("出力項目の確認", PerformanceCSVExport.checkCollectorDefinition(getCollectorProperty3(), csvCols7()));
	}

	/**
	 * 性能項目定義1
	 * 
	 * @return
	 */
	private CollectorProperty getCollectorProperty1() {
		CollectorProperty property = new CollectorProperty();

		ArrayList<CollectorItemInfo> itemInfos = new ArrayList<CollectorItemInfo>();
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "CPU0100_CPU_UTIL", ""));

		property.setItemList(itemInfos);

		return property;
	}

	/**
	 * 性能項目定義2
	 * 
	 * @return
	 */
	private CollectorProperty getCollectorProperty2() {
		CollectorProperty property = new CollectorProperty();

		ArrayList<CollectorItemInfo> itemInfos = new ArrayList<CollectorItemInfo>();
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "NET0100_PACKET", "eth1"));

		property.setItemList(itemInfos);

		return property;
	}

	/**
	 * 性能項目定義3
	 * 
	 * @return
	 */
	private CollectorProperty getCollectorProperty3() {
		CollectorProperty property = new CollectorProperty();

		ArrayList<CollectorItemInfo> itemInfos = new ArrayList<CollectorItemInfo>();
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "CPU0100_CPU_UTIL", ""));
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "MEM0100_MEM_UTIL", ""));
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "FS_0100_DVC_UTIL", "/"));
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "FS_0100_DVC_UTIL", "/boot"));
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "FS_0100_DVC_UTIL", "/var"));
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "NET0100_PACKET", "eth0"));
		itemInfos.add(new CollectorItemInfo("collectorID", "SNMP", "NET0100_PACKET", "eth1"));

		property.setItemList(itemInfos);

		return property;
	}

	/**
	 * 出力項目定義1
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols1() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));

		return csvCols;
	}

	/**
	 * 出力項目定義2
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols2() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "MEM0100_MEM_UTIL", ""));

		return csvCols;
	}

	/**
	 * 出力項目定義3
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols3() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "NET0100_PACKET", "eth0"));

		return csvCols;
	}

	/**
	 * 出力項目定義4
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols4() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "NET0100_PACKET", "eth1"));

		return csvCols;
	}

	/**
	 * 出力項目定義5
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols5() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("FS /var", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth0"));

		return csvCols;
	}
	
	/**
	 * 出力項目定義6
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols6() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("FS /var", "FS_0100_DVC_UTIL", "/boot"));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth3"));

		return csvCols;
	}
	
	/**
	 * 出力項目定義7
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols7() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth0"));
		
		return csvCols;
	}
}
