package com.clustercontrol.performance.rrdtool;

import java.io.File;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import com.clustercontrol.performance.rrdtool.PerformanceCSVExport;
import com.clustercontrol.performance.rrdtool.csv.CSVColumn;
import com.clustercontrol.performance.bean.CollectedDataInfo;

import junit.framework.TestCase;

public class PerformanceCSVExportUT004 extends TestCase {

	public PerformanceCSVExportUT004() {
		super();
	}

	public void setUp() throws Exception {
		super.setUp();
	}

	public void tearDown() throws Exception {
		super.tearDown();
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、それに該当する出力項目1つの場合
	 */
	public void testN01() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 1, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当しない出力項目1つの場合
	 */
	public void testN02() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth3"));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), false);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 0, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当する出力項目3つの場合
	 */
	public void testN03() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), true);
		retExpect.put(csvCols.get(2), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 3, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当しない出力項目3つの場合
	 */
	public void testN04() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTILXXX", null));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTILXXX", null));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTILXXX", "/"));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), false);
		retExpect.put(csvCols.get(1), false);
		retExpect.put(csvCols.get(2), false);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 0, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当する出力項目7つの場合
	 */
	public void testN05() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		csvCols.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		csvCols.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));
		
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), true);
		retExpect.put(csvCols.get(2), true);
		retExpect.put(csvCols.get(3), true);
		retExpect.put(csvCols.get(4), true);
		retExpect.put(csvCols.get(5), true);
		retExpect.put(csvCols.get(6), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 7, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当しない出力項目7つの場合
	 */
	public void testN06() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTILXXX", ""));
		csvCols.add(new CSVColumn("", "MEM0100_MEM_UTILXXX", ""));
		csvCols.add(new CSVColumn("", "FS_0100_DVC_UTILXXX", "/"));
		csvCols.add(new CSVColumn("", "FS_0100_DVC_UTILXXX", "/var"));
		csvCols.add(new CSVColumn("", "NET0100_PACKETXXX", "eth0"));
		csvCols.add(new CSVColumn("", "NET0100_PACKETXXX", "eth1"));
		csvCols.add(new CSVColumn("", "MEM0400_SWAP_IOXXX", ""));
		
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), false);
		retExpect.put(csvCols.get(1), false);
		retExpect.put(csvCols.get(2), false);
		retExpect.put(csvCols.get(3), false);
		retExpect.put(csvCols.get(4), false);
		retExpect.put(csvCols.get(5), false);
		retExpect.put(csvCols.get(6), false);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 0, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当する出力項目7つ（同一収集ID定義が2つ存在）の場合
	 */
	public void testN07() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		csvCols.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), true);
		retExpect.put(csvCols.get(2), true);
		retExpect.put(csvCols.get(3), true);
		retExpect.put(csvCols.get(4), true);
		retExpect.put(csvCols.get(5), true);
		retExpect.put(csvCols.get(6), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 6, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（特定日時の7項目）、該当する出力項目7つ（同一収集ID定義が7つ存在）の場合
	 */
	public void testN08() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), true);
		retExpect.put(csvCols.get(2), true);
		retExpect.put(csvCols.get(3), true);
		retExpect.put(csvCols.get(4), true);
		retExpect.put(csvCols.get(5), true);
		retExpect.put(csvCols.get(6), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos1();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 1, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（複数日時の7項目）、該当する出力項目3つの場合
	 */
	public void testN09() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), true);
		retExpect.put(csvCols.get(2), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos2();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 36, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（複数日時の7項目）、該当する出力項目2つ、該当しない出力項目1つの場合
	 */
	public void testN10() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTILXXX", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), false);
		retExpect.put(csvCols.get(2), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos2();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 24, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * PerformanceCSVExport.examineCollectedDataInfoメソッド単体試験<br>
	 * 性能収集情報（誤差あり複数日時の7項目）、該当する出力項目2つ、該当しない出力項目1つの場合
	 */
	public void testN11() {
		
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTILXXX", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		
		HashMap<CSVColumn, Boolean> retExpect = new HashMap<CSVColumn, Boolean>();
		retExpect.put(csvCols.get(0), true);
		retExpect.put(csvCols.get(1), false);
		retExpect.put(csvCols.get(2), true);
		
		ArrayList<CollectedDataInfo> dataInfos = collectedDataInfos3();
		HashMap<CSVColumn, Boolean> ret = PerformanceCSVExport.examineCollectedDataInfo(dataInfos, csvCols);
		
		assertEquals("性能値の数の確認", 24, dataInfos.size());
		
		compareHash(retExpect, ret);
	}
	
	/**
	 * フラグのハッシュの比較
	 * @param objExpect
	 * @param obj
	 */
	private void compareHash(HashMap<CSVColumn, Boolean> objExpect, HashMap<CSVColumn, Boolean> obj) {
		
		assertEquals("ハッシュ要素数の確認", objExpect.size(), obj.size());
		
		for (int i = 0; i < objExpect.size(); i++) {
			assertEquals("要素値の確認", objExpect.get(i), obj.get(i));
		}
		
	}
	
	/**
	 * 性能値情報定義1
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos1() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		itemCodes.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));

		return collectedDataInfos("2008-06-10 8:00:00", 60, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義2
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos2() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		itemCodes.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));

		return collectedDataInfos("2008-06-10 8:00:00", 5, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義3
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos3() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		itemCodes.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));

		return collectedDataInfosBlur("2008-06-10 8:00:00", 5, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義の汎用生成メソッド
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos(String startDateStr, double minWidth, double hours,
			ArrayList<String> facilityIDs, ArrayList<CSVColumn> itemCodes) {

		ArrayList<CollectedDataInfo> collectedDataInfos = new ArrayList<CollectedDataInfo>();

		long startEpoch = 0;
		SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		int ratio = 0;

		try {
			startEpoch = dateformat.parse(startDateStr).getTime();
		} catch (ParseException e1) {
			fail("collectedDataInfos1 failed");
			e1.printStackTrace();
		}

		for (String facilityID : facilityIDs) {
			for (int i = 0; i < hours * 60 / minWidth; i++) {
				ratio = 0;
				for (CSVColumn itemCode : itemCodes) {
					if (ratio == 0) {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i)), Math.pow(-1, i)
								* 0.01 * i));
					} else {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i)), Math.pow(-1, i)
								* (Math.pow(10, ratio - 1) + 0.01 * i)));
					}
					ratio++;
				}
			}
		}

		return collectedDataInfos;
	}
	
	/**
	 * 性能値情報定義の汎用生成メソッド（収集日時ずれあり）
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfosBlur(String startDateStr, double minWidth, double hours,
			ArrayList<String> facilityIDs, ArrayList<CSVColumn> itemCodes) {

		ArrayList<CollectedDataInfo> collectedDataInfos = new ArrayList<CollectedDataInfo>();

		long startEpoch = 0;
		SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		int ratio = 0;
		int blursec = 30;

		try {
			startEpoch = dateformat.parse(startDateStr).getTime();
		} catch (ParseException e1) {
			fail("collectedDataInfos1 failed");
			e1.printStackTrace();
		}

		for (String facilityID : facilityIDs) {
			for (int i = 0; i < hours * 60 / minWidth; i++) {
				ratio = 0;
				for (CSVColumn itemCode : itemCodes) {
					if (ratio == 0) {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i) + blursec * ratio * 1000), Math.pow(-1, i)
								* 0.01 * i));
					} else {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i) + blursec * ratio * 1000), Math.pow(-1, i)
								* (Math.pow(10, ratio - 1) + 0.01 * i)));
					}
					ratio++;
				}
			}
		}

		return collectedDataInfos;
	}
}
