/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.repository.action.GetNodeProperty;

/**
 * ノード属性一覧コンポジットクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeAttributeComposite extends Composite {

    // ----- instance フィールド ----- //

    /** テーブルビューア */
    private PropertySheet propertySheet = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent
     *            親のコンポジット
     * @param style
     *            スタイル
     */
    public NodeAttributeComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    // ----- instance メソッド ----- //

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        TableTree table = new TableTree(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);
    }

    /**
     * PropertySheetを返します。
     * 
     * @return PropertySheet
     */
    public PropertySheet getPropertySheet() {
        return this.propertySheet;
    }

    /**
     * 指定されたノードの情報を表示します。
     * 
     * @param facilityId
     *            ファシリティID
     */
    public void update(String facilityId) {
        Property data = null;

        data = new GetNodeProperty().getProperty(facilityId,
                PropertyConstant.MODE_SHOW);
        
        if(data == null){
        	data = new Property(null, null, "");
        }

        this.propertySheet.setInput(data);
        
        
        /*プロパティシートの展開を指定します。*/
        
       
        //レベル1までの展開（デバイス情報、ファイルシステム情報は展開しない。）
        this.propertySheet.expandToLevel(1);
        //ネットワークのインデックスは6
        Object element =  this.propertySheet.getElementAt(6);
        this.propertySheet.expandToLevel(element, 3);
        
        //OSのインデックスは7
         element =  this.propertySheet.getElementAt(7);
        this.propertySheet.expandToLevel(element, 3);
        
        //保守のインデックスは9
        element =  this.propertySheet.getElementAt(9);
       this.propertySheet.expandToLevel(element, 3);
        
    }
}